package java.awt;

import java.awt.event.*;

class MenuBarComponent extends Component {
    
    MenuBar bar;
    Menu open;
    int selected = -1;

    MenuBarComponent (MenuBar bar) {
	this.bar = bar;
    }


    public Dimension getMinimumSize () {
	return new Dimension (160, 15);
    }


    public void paint (Graphics g) {

	g.setColor (Color.black);
	g.drawLine (1, 0, w-3, 0);
	g.drawLine (1, h-2, w-2, h-2);
	g.drawLine (2, h-1, w-3, h-1);
	
	g.drawLine (0, 1, 0, h-3);
	g.drawLine (w-2, 1, w-2, h-2);
	g.drawLine (w-1, 2, w-1, h-3);

	g.setFont (g.getFont ().deriveFont (Font.BOLD));
	int x = 10;

	for (int i = 0; i < bar.menus.size (); i++) {
	    Menu m = (Menu) bar.menus.elementAt (i);

	    String label = m.label;
	    int w = g.getFontMetrics ().stringWidth (label)+10;	    
	    
	    g.setColor (i == selected 
			? SystemColor.activeCaption 
			: Color.white);
	   
	    g.fillRect (x-5, 1, w, h-3);  
	    g.setColor (i == selected ? Color.white : Color.black);

	    g.drawString (label, x, 12);

	    x += w;
	}

	g.setColor (Color.black);
    }


    void setSelected (int i, int xofs) {
	
	if (selected != i) {
	    selected = i;
	    Graphics g = getGraphics ();
	    if (g != null) paint (g); else repaint ();
	}

	Menu toOpen = i == -1 ? null : (Menu) bar.menus.elementAt (i);

	if (open != toOpen && open != null) open.win.setVisible (false);

	open = toOpen;

	if (open != null) open.show (xofs);
    }
			     

    public void processMouseEvent (MouseEvent me) {
    
	if (me.getID () != me.MOUSE_DRAGGED 
	    && me.getID () != me.MOUSE_PRESSED) return;

	int xofs = 5;
	int mx = me.getX ();
	
	Graphics g = getGraphics();
	if (g == null) return;
		
	g.setFont (g.getFont ().deriveFont (Font.BOLD));
	FontMetrics fm = g.getFontMetrics();
		
	for (int i = 0; i < bar.menus.size(); i++) {
	    
	    int nextOfs = xofs + 10 + 
	  	  fm.stringWidth (((Menu) bar.menus.elementAt(i)).label);
	    
	    if (mx >= xofs && mx < nextOfs) { 
		setSelected (i, xofs);
		return;
	    }
	    xofs = nextOfs;
	}

	setSelected (-1, xofs);
    }
}
