
package java.io;

public class FileOutputStream extends OutputStream {

    RandomAccessFile raf;

    public FileOutputStream (File file) throws IOException {
	
	raf = new RandomAccessFile (file, "w");
    }


    public void close () throws IOException {
	raf.setLength (raf.getFilePointer ());
	raf.close ();
    }
    

    public void write (int b) throws IOException {
	raf.write ((byte) b);
    }


    public void write (byte [] buf, int off, int len) throws IOException {
	raf.write (buf, off, len);
    }
}
