package java.awt;

import java.awt.event.*;

public class ScrollPane extends Container {
    
    Component child;
    ScrollManager scrollManager;

    public ScrollPane () {
	children = null;  
	scrollManager = new ScrollManager 
	    (this, ScrollManager.BORDER_SINGLE);
    }


    public Component add (String where, Component c) {
	child = c;
	c.parent = this;
	invalidate ();
	return c;
    }


    public void paintAll (Graphics g) {

	if (child == null || !visible) return;

	scrollManager.paint (g);
       	child.x = -scrollManager.xOffset;
	child.y = -scrollManager.yOffset;
	
	Graphics g2 = g.create (child.x, child.y, child.w, child.h);

	child.paintAll (g2);
    }
    


    public synchronized void doLayout () {  

	if (child == null) return;

	Dimension d = child.getPreferredSize ();
	scrollManager.doLayout (d.width, d.height);

	if (d.width < scrollManager.viewPortW) 
	    d.width = scrollManager.viewPortW;

	if (d.height < scrollManager.viewPortH) 
	    d.height = scrollManager.viewPortH;

	child.setSize (d);	
	child.doLayout ();
    }

    
    public Component findComponentAt (int px, int py) {

	Component target = scrollManager.findComponentAt (px, py);
	if (target != this) return target;
	return child.findComponentAt (px-child.x, py-child.y);
    }


    public Point getScrollPosition () {
	
	return new Point 
	    (scrollManager.hBar != null ? scrollManager.hBar.currValue : 0,
	     scrollManager.vBar != null ? scrollManager.vBar.currValue : 0);
    }
}
