// Authors: Stefan Haustein (SH), Michael Kroll (MK)
//
// 2000-06-19 SH List replaced by TextArea (I will include both on scroll pane)
// 2000-05-20 SH Changed to modal dialog
// 1999-08-19 SH initial release
// 1999-08-29 SH added TestDialog
// 1999-09-02 MK added TabbedPane
// 1999-11-07 MK version 0.11 released
// 1999-11-22 MK version 0.12 released
// 1999-11-28 MK version 0.2 released
// 1999-12-05 MK version 0.21 released
// 1999-12-15 MK version 0.22 released
// 2000-02-17 MK version 0.23 released
// 2000-03-04 MK version 0.24 released
// 2000-03-06 MK version 0.25 released
// 2000-05-22 MK version 0.60 released
// 2000-06-25 MK version 0.70 released
// 2000-07-18 MK version 0.80 released
// 2000-07-24 MK version 0.81 released


import java.awt.*;
import java.awt.event.*;
import de.kawt.*;

class LayoutPanel extends Panel implements ActionListener {
    
    LayoutManager saveBorder;
    Frame frame;
    
    LayoutPanel (Frame frame) {
	
	super (new BorderLayout ());
	this.frame = frame;
	addButton ("North", "grid");
	addButton ("South", "border");
	addButton ("East", "flow");
	addButton ("West", "exit");
	addButton ("Center", "dialog");
	saveBorder = getLayout ();
	validate ();
    }

    void addButton (String where, String label) {
	Button b = new Button (label);
	add (where, b);
	b.addActionListener (this);
	b.setActionCommand (label);
    }
                     

    
    public void actionPerformed (ActionEvent e) {
	String cmd = e.getActionCommand ();
	if (cmd.equals ("grid")) 
	    setLayout (new GridLayout (3, 2));
	else if (cmd.equals ("flow"))
	    setLayout (new FlowLayout ());
	else if (cmd.equals ("border"))
	    setLayout (saveBorder);
	else if (cmd.equals ("dialog")) {
	    if (OptionDialog.showConfirmDialog 
		(frame, "Do you like kAWT?", "Sample Dialog") 
		== OptionDialog.NO_OPTION)
		OptionDialog.showInputDialog 
		    (frame, "Why do you use it then?");
	}
	else if (cmd.equals ("exit")) 
	    System.exit (0);
	validate ();
    }
}

class MemPanel extends Canvas {

    public void paint (Graphics g) {

	Dimension d = getSize ();

	int m = d.width > d.height ? d.height : d.width;
	int step = m / 10; 

	g.setColor (new Color (127, 127, 127));
	g.fillRect (0, 0, d.width, d.height);

	g.setColor (Color.white);

	for (int i = step/2; i < d.width; i+= step)
	    g.drawLine (i, 0, i, d.height);

	for (int i = step/2; i < d.height; i+= step)
	    g.drawLine (0, i, d.width, i);

	g.translate ((d.width - m) / 2, (d.height - m) / 2);
	g.fillRect (step, step, 8*step, 8*step); 

	for (int i = 0; i < 8; i++) {
	    g.setColor (new Color (((i & 1) * 255) ,
				 ((i & 2) >> 1) * 255 ,
				 ((i & 4) >> 2) *255));

	    g.fillRect ((i+1) * step, step, step, 2*step+step/2);
	    
	    int gray = 255 / 8 * i;
	    g.setColor (new Color (gray, gray, gray));

	    g.fillRect ((i+1) * step, 3*step+step/2, step, step+step/2);

	}
	    
	g.setColor (Color.white);
	g.drawOval (0, 0, m, m);

	int ty = 6*step;

	g.setColor (Color.black);

	g.drawString ("total mem: "+ Runtime.getRuntime().totalMemory(), 2*step, ty);
	g.drawString ("free mem: "+Runtime.getRuntime().freeMemory (), 2*step, ty+step);
	Runtime.getRuntime().gc();
	g.drawString ("post gc: "+Runtime.getRuntime ().freeMemory (), 2*step, ty+2*step);

	
    }

    public Dimension getPreferredSize () {
	return new Dimension (160, 160);
    }
}


class MiscPanel extends Panel implements ActionListener, ItemListener { 
    Frame frame;
    Checkbox checkBox1;
    Checkbox checkBox2;
    Checkbox titlebox;
    TextField tf;

    MiscPanel (Frame frame) {
	super (new GridLayout (0, 1));
	this.frame = frame;
	CheckboxGroup group = new CheckboxGroup ();
	
	checkBox1 = new Checkbox ("Public text", group, false);
	checkBox1.addItemListener (this);
	checkBox2 = new Checkbox ("Hidden text", group, false);
	checkBox2.addItemListener (this);

	add (checkBox1); 
	add (checkBox2);

	titlebox = new Checkbox ("Show Frame Title", true);
	titlebox.addItemListener (this);
	add (titlebox);
	
	tf = new TextField ("Test");
	add (tf);

	Choice choice = new Choice ();
	choice.add ("red");
	choice.add ("green");
	choice.add ("blue");
	add (choice);
	addButton ("beep");
	addButton ("exit");
    }
    
    void addButton (String label) {
	Button b = new Button (label);
	add (b);
	b.addActionListener (this);
	b.setActionCommand (label);
    }
    
    public void itemStateChanged (ItemEvent ev) {
 	if (ev.getStateChange () == ev.SELECTED && ev.getSource () == titlebox) {
	    frame.setTitle ("kAWT Sample v0.81");
	    frame.validate ();	
	}
	else if (ev.getStateChange () == ev.DESELECTED && ev.getSource () == titlebox) {
	    frame.setTitle (null);
	    frame.validate ();	
	}
	else if (ev.getStateChange () == ev.SELECTED && ev.getSource () == checkBox1) {
	    tf.setEchoChar ('\0');
	    tf.setText (tf.getText ());
	}
	else if (ev.getStateChange () == ev.SELECTED && ev.getSource () == checkBox2) {
	    tf.setEchoChar ('*');
	    tf.setText (tf.getText ());
	}
	
	

    }
    
    public void actionPerformed (ActionEvent ev) {
	if (ev.getActionCommand ().equals ("beep")) {
	    Toolkit.getDefaultToolkit ().beep ();
	}
	else System.exit (0);
  }
}

class ScrollbarPanel extends Panel implements AdjustmentListener, ActionListener {
    Label label;
    Scrollbar horizontal;

    ScrollbarPanel (Frame frame) {
	super (new BorderLayout ());

	Panel center = new Panel (new GridLayout (2, 2));

	label = new Label ();
	horizontal = new Scrollbar (Scrollbar.HORIZONTAL);
	horizontal.addAdjustmentListener (this);
    
        java.awt.List list = new java.awt.List ();

	for (int i= 0; i < 20; i++)	
	    list.add ("item "+i);

	center.add (list);

	ScrollPane sp = new ScrollPane ();
	sp.add (new MemPanel ());
	center.add (sp);
	
	TextArea ta = new TextArea ();
	    
	ta.setText ("This is an example\nof a simple TextArea\nwith hard line breaks.\n01\n02\n03\n04\n05\n06\n07\n08\n09\n10\n11\n12\n13\n14\n15\n16\n17\n18\n19\n20\n");
	
	center.add (ta);
	

	Button exitB = new Button ("exit");
	exitB.addActionListener (this);
	exitB.setActionCommand ("exit");
	center.add (exitB);

	add ("North", label);
	add ("Center", center);
	add ("South", horizontal);
	adjustmentValueChanged (null);

	validate ();
    }
    
    public void adjustmentValueChanged (AdjustmentEvent ev) {
	label.setText ("Pos h: "+horizontal.getValue ());
    }
    
    public void actionPerformed (ActionEvent e) {
	String cmd = e.getActionCommand ();
	if (cmd.equals ("exit")) 
	    System.exit (0);
    }
}

class Closer extends WindowAdapter {
    public void windowClosing (WindowEvent e) {
	System.exit (0);
    }
}

public class KawtSample extends Frame implements ActionListener {
    Dialog dialog;
    TabbedPane tabPane;

    KawtSample () {
	setTitle ("kAWT Sample v0.81");

	MenuBar menuBar = new MenuBar ();
	Menu menu = new Menu ("About");
	MenuItem mi = new MenuItem ("About kAWT");
	mi.addActionListener (this);
	menu.add (mi);
       
	menu.add (new MenuItem ("An uselsess entry"));
	menuBar.add (menu);

	menu = new Menu ("Test");

	menuBar.add (menu);
	menu.add (new MenuItem ("Test 1"));
	menu.add (new MenuItem ("Test 2"));
	menu.add (new MenuItem ("Test 3"));
	setMenuBar (menuBar);


	tabPane = new TabbedPane();
	tabPane.addTab ("Layout", new LayoutPanel (this));
	tabPane.addTab ("Misc", new MiscPanel (this));
	tabPane.addTab ("Scroll", new ScrollbarPanel (this));
	tabPane.addTab ("Color", new MemPanel ());
	add ("Center", tabPane);
	
	addWindowListener (new Closer ());
	pack ();
    }
    
    public static void main (String [] argv) {
	new KawtSample ().show ();
    }

    public void actionPerformed (ActionEvent e) {
	OptionDialog.showMessageDialog 
	    (this, "Sample app, see www.kawt.de");
    } 

}






