package de.kawt;

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import java.io.*;

import de.kawt.shell.*;


public class FileList extends Panel implements MouseListener, ItemListener  {

    boolean active;
    List list = new List ();
    Label title = new Label ();
    AbstractShell shell;
    FileListActivationListener activationListener;
    
    public FileList (FileListActivationListener activationListener) {
	super (new BorderLayout ());
	
	add ("North", title);	
	add ("Center", list); 

	title.addMouseListener (this);
	list.addItemListener (this);

	this.activationListener = activationListener;
	
	setShell (new DefaultShell ());
	
	active = true;
	setActive (false);
    }

    

    public void setShell (AbstractShell shell) {
	this.shell = shell;
	cd (shell.pwd ());
    }

    public AbstractShell getShell () {
	return shell;
    }


    public String getSelectedFile () {
	return list.getSelectedItem ();
    }

    public void cd (String path) {

	shell.cd (path);
	//title.repaint ();
	title.setText (shell.pwd ());

	Vector l = shell.ls ();

	list.removeAll ();
	for (int i= 0; i < l.size (); i++) {
	    list.add (l.elementAt (i).toString ());
	}
    }

    public void itemStateChanged (ItemEvent e) {
	if (e.getStateChange () == e.SELECTED) 
	    setActive (true);
    }

    
    public void mouseClicked(MouseEvent e) {
	setActive (true);
    } 

    public void mouseEntered(MouseEvent e) {} 
    public void mouseExited(MouseEvent e) {} 
    public void mousePressed(MouseEvent e) {}
    public void mouseReleased(MouseEvent e) {} 
   

    public void setActive (boolean active) {

	if (this.active == active) return;

	this.active = active;
	
	if (active) { 
	    title.setBackground (SystemColor.activeCaption);
	    title.setForeground (SystemColor.activeCaptionText);
	    if (activationListener != null)
		activationListener.fileListActivated (this);
	}
	else {
	    title.setBackground (SystemColor.inactiveCaption);
	    title.setForeground (SystemColor.inactiveCaptionText);
	    list.deselect (list.getSelectedIndex ());
	}
    }
}

