package de.kawt;

import java.awt.*;
import java.awt.image.*;

public class ImageItem extends Canvas {

    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int INVERSE = 4;

    static Image [] images = new Image [8]; 
    
    Image image;

    public ImageItem (Image image) {
	this.image = image; 
	//setPreferredSize (image.getWidth (this), image.getHeight (this));
	//	setPreferredSize (image.getWidth (), image.getHeight);
    }
    
    public void paint (Graphics g) {
	g.drawImage (image, 0, 0, this);
    }
    
    
    public static Image getImage (int type) {
	if (images [type] == null) {
	    byte [] data = null;
	    
	    switch (type) {
	    case UP: 
		data = new byte [] {
		    71,73,70,56,57,97,7,0,6,0,
		    -128,0,0,-1,-1,-1,0,0,0,44,
		    0,0,0,0,7,0,6,0,0,2,
		    10,-124,-113,-127,16,125,13,25,-116,11,
		    20,0,59};
		
		break;
	    case DOWN:
		data = new byte [] {
		    71,73,70,56,57,97,7,0,6,0,
		    -128,0,0,-1,-1,-1,0,0,0,44,
		    0,0,0,0,7,0,6,0,0,2,
		    10,-124,15,-95,27,-55,-73,80,-110,-78,
		    0,0,59};
		break;
		
	    case LEFT:
		data = new byte [] {
		    71,73,70,56,57,97,6,0,7,0,
		    -128,0,0,-1,-1,-1,0,0,0,44,
		    0,0,0,0,6,0,7,0,0,2,
		    12,-124,17,-121,105,-31,-19,-40,-110,75,
		    33,80,0,0,59};
		break;
		
	    case RIGHT: 
		data = new byte [] {
		    71,73,70,56,57,97,6,0,7,0,
		    -128,0,0,-1,-1,-1,0,0,0,44,
		    0,0,0,0,6,0,7,0,0,2,
		    12,68,-128,24,-105,-53,-26,-44,106,-49,
		    36,80,0,0,59};
		break;
		
	    case (UP|INVERSE):
		data = new byte [] {
		    71,73,70,56,57,97,7,0,6,0,
		    -128,0,0,-1,-1,-1,0,0,0,44,
		    0,0,0,0,7,0,6,0,0,2,
		    10,-116,-113,-128,1,125,13,25,-116,43,
		    20,0,59};
		break;
		
	    case (DOWN|INVERSE):
		data = new byte [] {
		    71,73,70,56,57,97,7,0,6,0,
		    -128,0,0,-1,-1,-1,0,0,0,44,
		    0,0,0,0,7,0,6,0,0,2,
		    10,-116,31,-96,11,-55,-73,80,-110,-78,
		    0,0,59};
		
		break;
		
	    case LEFT|INVERSE:
		data = new byte [] {
		    71,73,70,56,57,97,6,0,7,0,
		    -128,0,0,-1,-1,-1,0,0,0,44,
		    0,0,0,0,6,0,7,0,0,2,
		    12,-116,3,-121,105,-32,-19,-40,-110,75,
		    -95,80,0,0,59};
		break;
		
	    default:
		data = new byte [] {
		    71,73,70,56,57,97,6,0,7,0,
		    -128,0,0,-1,-1,-1,0,0,0,44,
		    0,0,0,0,6,0,7,0,0,2,
		    12,12,-126,8,-105,-53,-26,-44,106,-49,
		    -92,80,0,0,59};
	    }	
	    
	    images [type] = Toolkit.getDefaultToolkit ().createImage (data);
	}
	return images [type];
    }
}
