package de.kawt.shell;

import java.util.Vector;
import java.io.*;

public abstract class AbstractShell {

    protected long transferSize;

    public abstract boolean cd (String newDir);
    public abstract Vector ls ();
    public abstract void mkdir (String name);

    public void close () {
    }

    /** needed to enable ftpshell to close data connection */

    public void closeStream () throws IOException {}


    public abstract InputStream getInputStream (String name) throws IOException;
    public abstract OutputStream getOutputStream (String name) throws IOException;
    public abstract String pwd ();
    public abstract void rm (String name);

    public long getTransferSize () {
	return transferSize;
    }

    
    //public abstract int getSize (String name);
} 

