//#ifndef giftest
package java.awt;
//#endif

import java.io.*;
import java.awt.Toolkit;

public class GifLoader  {

//#ifndef midp
  int globalWidth;
  int globalHeight;
  int colorResolution;
  int globalPixelBits;
  int background;
  byte [] globalColorMap;
  InputStream is;

  static final int [] interlaceMap 
  = { 0,  8,  4, 12,  2,  6, 10,
      1,  3,  5,  7,  9, 11};
  
  int top;
  int left;
  int width;
  int height;
  int bufPos;
  //int bitPos;
  int resetCode;
  int eofCode;

  int pixelBits;
  int colors;
  byte [] colorMap;
  byte [] buf;
  byte [] writeBuf;
  int writePos;
  
  int blockSize;
  int row;
  
  short [] prefix;
  byte [] suffix;
  byte [] stack;
  
  int screenBits = Toolkit.getDefaultToolkit ().getColorModel ().getPixelSize ();// = System.getProper;
  
  int codeSize;
  int clearCode;
  int firstFree;
  int freeCode;
  int maxCode;
  int minCodeSize;
  int tableSize;
  int tableLimit;
  int x;
  int y;
  
  boolean interlaced;

//#ifndef giftest
   Image image;
//#endif

  int current;
  int filled;
  int mask;
  
  public GifLoader (InputStream is) {
    this.is = is;
  }
  
//#ifdef giftest 
//#   public void load () throws IOException {
//#else
   public Image load () throws IOException {
    //#endif
    buf = new byte [256];
    
    readBytes (buf, 6);
    
//#ifdef giftest
//#     System.out.println ("Signature: "+new String (buf));
//#endif

    globalWidth = readWord ();
    globalHeight = readWord ();
    
//#ifdef giftest
//#     System.out.println ("globalWidth: "+globalWidth + " globalHeight: "+globalHeight);
//#endif

    int misc = is.read ();

    colorResolution = ((misc >> 4) & 7) + 1;
    globalPixelBits = (misc & 7)  + 1;
    background = is.read ();
    
//#ifdef giftest
//#     System.out.println ("cr: "+colorResolution
//# 			+ " pixelBitsGlobal: "+ globalPixelBits
//# 			+ " bg: " + background);
//# 
//#     if (is.read () != 0)
//#       throw new RuntimeException ("GIF Format error: 0 expected");
//#else
	is.read ();
//#endif

    if ((misc & 128) != 0) {
//#ifdef giftest
//#       System.out.println ("Reading global color map");
//#endif
      globalColorMap = new byte [(1 << globalPixelBits)];
      readColorMap (globalColorMap, globalColorMap.length);
    }
//#ifdef giftest
//#     else System.out.println ("no global color map");
//#else
	image = new Image (globalWidth, globalHeight, screenBits);
//#endif
    writeBuf = new byte [globalWidth+16];

    while (true) {
      int st = is.read ();
      switch (st) {
      case ',': readImage (); break;
      case '!': readExtension (); break;
      case -1:
      case 0:
      case ';':
//#ifdef giftest
//# 		return;
//#else
		return image;
//#endif
      default: throw new RuntimeException ("bst#"+st);
      }
    }
  }

  void readExtension ()  throws IOException{
    is.read (); // extension code
    while (true) {
      int cnt = is.read ();
      //System.out.println ("extension size: "+cnt);
      if (cnt <= 0) break;
      
      readBytes (buf, cnt);
    }
  }
  

    void readBytes (byte [] buf, int count) throws IOException {

	int pos = 0;
	do {
	    int ok = is.read (buf, pos, count-pos);
	    if (ok == -1 || ok == 0) break;
	    pos += ok;
	}
	while (pos < count);
    
	if (count != pos)
	    throw new RuntimeException ("Read past eof!");
    }
  
    int readWord () throws IOException {
	int b = is.read ();
	return b | (is.read () << 8);
    }


    void initTable () {
	codeSize = minCodeSize + 1;
	clearCode = 1 << minCodeSize;
	eofCode = clearCode + 1;
	firstFree = clearCode + 2;
	freeCode = firstFree;
	maxCode = 1 << codeSize;
	
	mask = (1 << codeSize) - 1;
    }

    void expandData () throws IOException {
	
	minCodeSize = is.read ();

	initTable ();
	
	prefix = new short [maxCode - firstFree];
	suffix = new byte [maxCode - firstFree];
	stack = new byte [maxCode - firstFree + 1];

	
	int oldCode = 0;
	int suffixChar;
	int finalChar = 0;
	int inputCode;
	int sp = 0;

	while (true) {
	    int code = readCode ();
	    if (code == eofCode) break;
	    if (code == clearCode) {
		initTable ();
		code = readCode ();
		oldCode = code;
		suffixChar = code;
		finalChar = code;
		putByte (suffixChar);
	    }
	    else {
		inputCode = code;
		if (code >= freeCode) {
		    code = oldCode;
		    stack [sp++] = (byte) finalChar;
		}
	
		while (code >= firstFree) {
		    stack [sp++] = suffix [code - firstFree];
		    code = prefix [code - firstFree];
		}
		
		finalChar = code;
		suffixChar = code;
		stack [sp++] = (byte) finalChar;
		
		while (sp > 0) 
		    putByte (stack [--sp]);
		
		suffix [freeCode - firstFree] = (byte) suffixChar;
		prefix [freeCode - firstFree] = (short) oldCode;
		
		freeCode++;
		oldCode = inputCode;
		
		if (freeCode >= maxCode) 
		    if (codeSize < 12) {
			codeSize++;
			mask = (1 << codeSize) - 1;
			maxCode <<= 1;
			
			if (prefix.length < maxCode) {
			    short [] tmps = prefix;
			    prefix = new short [maxCode - firstFree];
			    System.arraycopy (tmps, 0, prefix, 0, tmps.length);
			    
			    byte [] tmp = suffix;
			    suffix = new byte [maxCode - firstFree];
			    System.arraycopy (tmp, 0, suffix, 0, tmp.length);

			    tmp = stack;
			    stack = new byte [maxCode - firstFree + 1];
			    System.arraycopy (tmp, 0, stack, 0, tmp.length);
			}
		    }
	    }
	}
    }
    


    void readImage () throws IOException {
	
	left = readWord ();
	top = readWord ();
	width = readWord ();
	height = readWord ();
    
	row = 0;
	
	int misc = is.read ();
    
	interlaced = (misc & 64) != 0;

//#ifdef giftest
//#     System.out.println ("left: "+left + " top: "+top
//# 			+ " width: "+width + " height: "+height
//# 			+ " interlaced: "+interlaced);
//#endif

	pixelBits = globalPixelBits;
	if ((misc & 128) != 0) {
	    pixelBits = (misc & 7) + 1;
//#ifdef giftest 
//#       System.out.println ("Reading local color map");
//#endif
	    colorMap = new byte [ 1 << pixelBits ];
	    readColorMap (colorMap, colorMap.length);
	}
	else {
//#ifdef giftest
//#       System.out.println ("no local color map");
//#endif
	    colorMap = globalColorMap;
	}
	
	writePos = 0;
	colors = 1 << pixelBits;
	blockSize = 0;
	bufPos = 0;

	expandData ();
    }


    void readColorMap (byte [] map, int len) throws IOException {
	
	for (int i = 0; i < len; i++) {
	    int r = 255-is.read ();
	    int g = 255-is.read ();
	    int b = 255-is.read ();

	    if (screenBits < 8) {
		map [i] = (byte) (((r + g + b) / 3)
				  >> (8-screenBits));
	    }
	    else {
		r /= 43;
		g /= 43;
		b /= 43;
		map [i] = (byte) (g
				  + (6 * (b % 3))
				  + r * 3 * 6
				  + (b / 3) * 3 * 6 * 6);
	    }
	    
	    
      //	    System.out.println ("r="+r+" g="+g+" b="+b + " map="+map[i]);
	    
	    
	}
    }


    void putByte (int code) {
	writeBuf [writePos] = colorMap [code & 0x0ff];
	if (++writePos >= width) {

//#ifdef giftest
//#       for (int i = 0; i < width; i++)
//# 	System.out.print ((char) (writeBuf [i]+65));
//#       System.out.println ();
//# 
//#else

	    int dy = top + (interlaced && row + 13 <= height
			    ? (13 * (row / 13)) + interlaceMap [row % 13]
			    : row);
	    
	    image.setPixels (left, dy, width, 1, null, writeBuf, 0, width);
//#endif

	    writePos = 0;
	    row++;
	}
    }
    

    int readCode () throws IOException {
      
	while (filled < codeSize) {
	    
	    if (bufPos >= blockSize) {
		blockSize = is.read ();
		readBytes (buf, blockSize);
		bufPos = 0;
	    }
	    
	    current |= (((int) buf [bufPos++]) & 255) << filled;
	    filled += 8;
	}
      
	int result = current & mask;
	
	filled -= codeSize;
	current = current >> codeSize;
      
	//	System.out.println ("rc: "+(current & mask));
	return result;
    }
    
    /*
    int readBit () throws IOException {


	int result = ((buf [bufPos]) >> bitPos) & 1;

	//System.out.println ("readBit ("+bufPos+":"+bitPos+") ="+result);

	bitPos++;
	if (bitPos == 8) {
	    bitPos = 0;
	    bufPos++;
	}

	return result;
    }

    void writeByte (int b) {

    }
    */


//#endif
//#ifdef giftest
//# 
//#     public static void main (String [] argv) throws IOException {
//# 
//# 	new GifLoader (new FileInputStream (new File (argv [0]))).load ();
//# 
//# 	System.out.println ("Ready!");
//# 
//#     }
//# 
//#endif



}

