package java.awt;


import java.awt.event.*;

// (C) 2000 Stefan Haustein, Michael Kroll
//
// 2000-08-06 SH fixes for MIDP
// 2000-05-19 SH Initial version

class KawtThread extends Thread {

    Component target;
    AWTEvent event;
    int type;
    KawtThread save;
    

    public synchronized void run () {

	do {
	    try {
		wait (500);
	    }
	    catch (InterruptedException e) {}

	    try {
		switch (type) {
		case 'k': target.processKeyEvent ((KeyEvent) event); break;
		case 'm': target.processMouseEvent ((MouseEvent) event); break;
		default: Wrapper.wrapper.flushRepaint ();
		}
	    }
	    catch (Exception e) {		
		de.kawt.OptionDialog.showMessageDialog 
		    (Wrapper.wrapper.getActiveFrame (), 
		     e.toString ());
	    }

	    if (type != 0) {
		
		if (type == 'x') type = 'y';
		else type = 0;
		notify ();
	    }
	}
	while (type != 'y');
    }


    synchronized void processEvent (int type, Component target, 
			       AWTEvent event) {
	
	this.type = type;
	this.target = target;
	this.event = event;
	
	notify ();

	do {
	    try {
		wait ();
	    }
	    catch (InterruptedException e) {
	    }
	}
	while (this.type != 0);
    }
}



