package java.awt;

import java.util.Vector;


/** The kAWT TextArea currently does NOT support editing.
    It depends on hard line breaks and does not perform
    any word wrap. */

public class TextArea extends TextComponent {

    Vector content = new Vector ();
    int maxWidth = 100;
    int lineH = Toolkit.defaultTextHeight;

    ScrollManager scrollManager = new ScrollManager 
	(this, ScrollManager.BORDER_SINGLE);


    public void paintAll (Graphics g) {

	if (!visible) return;

	scrollManager.paint (g);

	int i = scrollManager.yOffset / lineH;
	int cy = Toolkit.defaultTextBaseline 
	    - (scrollManager.yOffset % lineH);
	int cx = 1 - scrollManager.xOffset;
	int len = content.size ();

	for (; cy < scrollManager.viewPortH + lineH && i < len; cy += lineH) 
	    g.drawString ((String) content.elementAt (i++), cx, cy);
    }

    
    public synchronized void doLayout () {  
	scrollManager.doLayout (maxWidth, content.size () * lineH);
    }

    
    public Component findComponentAt (int px, int py) {
	return scrollManager.findComponentAt (px, py);
    }

    
    public Dimension getPreferredSize () {
	return new Dimension (maxWidth + scrollManager.border, 
			      content.size () * lineH + scrollManager.border);
    }


    /** FIXME: currently, max width is not updated. */

    public void setText (String text) {

	content.removeAllElements ();

	int i0 = 0;

	while (true) {
	    int i = text.indexOf ('\n', i0);

	    if (i == -1) {
		content.addElement (text.substring (i0));
		break;
	    }

	    content.addElement (text.substring (i0, i));
	    i0 = i+1;
	}
	super.setText (text);
    }
}

