/*
 * Toolkit.java Version 0.11 99/11/07 
 *
 * History: (99/10/22) Version number 0.1 released
 *			(99/11/07) Version number 0.11 released
 *
 * Copyright 1999 by Stefan Haustein & Michael Kroll
 * 
 * stefan.haustein@trantor.de
 * michael.kroll@trantor.de
 *
 * All rights reserved.
 *
 * NO WARRANTY
 *
 *  1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
 *  WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
 *  LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
 *  HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
 *  WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
 *  NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
 *  QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
 *  PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
 *  SERVICING, REPAIR OR CORRECTION.
 * 
 *  2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
 *  WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
 *  MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
 *  LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
 *  INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
 *  INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
 *  DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
 *  OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
 *  OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * 
 *  END OF TERMS AND CONDITIONS */


package java.awt;

import java.io.*;
import java.awt.image.ColorModel;

public class Toolkit {

    // some package-internal shortcuts

    static final int defaultTextHeight = 12;
    static final int defaultTextBaseline = 10;

    static Toolkit defaultToolkit = new Toolkit ();
    static int pixelBits = System.getProperty ("kawt.colordepth") == null 
	? 1 : Integer.parseInt (System.getProperty ("kawt.colordepth"));
    static boolean colorKvm = System.getProperty ("kawt.colordepth") != null;


    public void beep () {
//#ifdef midp
//#else
	com.sun.kjava.Graphics.playSound
	    (com.sun.kjava.Graphics.SOUND_ALARM);
//#endif
    }
    
    public ColorModel getColorModel () {
	return new ColorModel (pixelBits);
    }
    
    
    static public Toolkit getDefaultToolkit () {
	return defaultToolkit;
    }
    

    public Dimension getScreenSize () {
	return new Dimension (Graphics.screenRect.width, 
			      Graphics.screenRect.height);
    }

//#ifdef midp
//#     public Image createImage (byte [] data) {
//# 	return new Image (javax.microedition.lcdui.Image.createImage
//# 			  (data, 0, data.length));
//#     }
//# 
//#else
    public Image createImage (byte [] data) {
	try {
	    InputStream is = new ByteArrayInputStream (data);

	    GifLoader loader = new GifLoader (is);

	    return loader.load ();
	}
	catch (IOException e) {
	    return null;
	}
    }


    /*public Image createImage (String filename) {
      try {
      InputStream is = new FileInputStream (new File (filename));
      
      GifLoader loader = new GifLoader (is);
      
      return loader.load ();
      }
      catch (IOException e) {
      return null;
      }
      }*/

//#endif
}



