//
// kAWT version 0.95
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS
// 

import java.awt.*;
import java.awt.event.*;
import de.kawt.*;

class LayoutPanel extends Panel implements ActionListener {
    
    LayoutManager saveBorder;
    Frame frame;
    
    LayoutPanel (Frame frame) {
	
	super (new BorderLayout ());
	this.frame = frame;
	addButton ("North", "grid");
	addButton ("South", "border");
	addButton ("East", "flow");
	addButton ("West", "exit");
	addButton ("Center", "dialog");
	saveBorder = getLayout ();
	validate ();
    }

    void addButton (String where, String label) {
	Button b = new Button (label);
	add (where, b);
	b.addActionListener (this);
	b.setActionCommand (label);
    }
                     

    
    public void actionPerformed (ActionEvent e) {
	String cmd = e.getActionCommand ();
	if (cmd.equals ("grid")) 
	    setLayout (new GridLayout (3, 2));
	else if (cmd.equals ("flow"))
	    setLayout (new FlowLayout ());
	else if (cmd.equals ("border"))
	    setLayout (saveBorder);
	else if (cmd.equals ("dialog")) {
	    if (OptionDialog.showConfirmDialog 
		(frame, "Do you like kAWT?", "Sample Dialog") 
		== OptionDialog.NO_OPTION)
		OptionDialog.showInputDialog 
		    (frame, "Why do you use it then?");
	}
	else if (cmd.equals ("exit")) 
	    System.exit (0);
	validate ();
    }
}

class MemPanel extends Canvas {

    public void paint (Graphics g) {

	Dimension d = getSize ();

	int m = d.width > d.height ? d.height : d.width;
	int step = m / 10; 
	m = step * 10;
	
	//int x0 = (d.width - step * 8) / 2;
	//int y0 = (d.width - step * 8) / 2;

	g.setColor (new Color (127, 127, 127));
	g.fillRect (0, 0, d.width, d.height);

	g.setColor (Color.white);

	for (int i = step/2; i < d.width; i+= step)
	    g.drawLine (i, 0, i, d.height);

	for (int i = step/2; i < d.height; i+= step)
	    g.drawLine (0, i, d.width, i);

	g.translate ((d.width - m) / 2, (d.height - m) / 2);
	g.fillRect (step, step, 8*step, 8*step); 

	for (int i = 0; i < 8; i++) {
	    g.setColor (new Color (((i & 1) * 255) ,
				 ((i & 2) >> 1) * 255 ,
				 ((i & 4) >> 2) *255));

	    g.fillRect ((i+1) * step, step, step, 2*step+step/2);
	    
	    int gray = 255 / 8 * i;
	    g.setColor (new Color (gray, gray, gray));

	    g.fillRect ((i+1) * step, 3*step+step/2, step, step+step/2);

	}
	    
	g.setColor (Color.white);
	g.drawOval (0, 0, m, m);

	int ty = 6*step;

	g.setColor (Color.black);

	boolean small = m < 100;

	g.drawString 
	    ((small ? "ttl " : "total mem: ")
	     + Runtime.getRuntime().totalMemory(), 2*step, ty);

	g.drawString 
	    ((small ? "fr " : "free mem: ") 
	     + Runtime.getRuntime().freeMemory (), 2*step, ty+step);

	Runtime.getRuntime().gc();

	g.drawString 
	    ((small ? "gc " : "post gc: ")
	     +Runtime.getRuntime ().freeMemory (), 2*step, ty+2*step);

	
    }

    public Dimension getPreferredSize () {
	return new Dimension (160, 160);
    }
}


class MiscPanel extends Panel implements ActionListener, ItemListener { 
    Frame frame;
    Checkbox checkBox1;
    Checkbox checkBox2;
    Checkbox titlebox;
    TextField tf;

    MiscPanel (Frame frame) {
	super (new GridLayout (0, 1));
	this.frame = frame;
	CheckboxGroup group = new CheckboxGroup ();
	
	checkBox1 = new Checkbox ("Public text", group, false);
	checkBox1.addItemListener (this);
	checkBox2 = new Checkbox ("Hidden text", group, false);
	checkBox2.addItemListener (this);

	add (checkBox1); 
	add (checkBox2);

	titlebox = new Checkbox ("Show Frame Title", true);
	titlebox.addItemListener (this);
	add (titlebox);
	
	tf = new TextField ("Test");
	add (tf);

	Choice choice = new Choice ();
	choice.add ("red");
	choice.add ("green");
	choice.add ("blue");
	add (choice);
	addButton ("beep");
	addButton ("exit");
    }
    
    void addButton (String label) {
	Button b = new Button (label);
	add (b);
	b.addActionListener (this);
	b.setActionCommand (label);
    }
    
    public void itemStateChanged (ItemEvent ev) {
	
	if (ev.getSource () == titlebox) {

	    if (ev.getStateChange () == ev.SELECTED) 
		frame.setTitle ("kAWT Sample v0.95");
	    else 
		frame.setTitle (null);
	    frame.validate ();	
	}
	else if (ev.getStateChange () == ev.SELECTED) {
	    tf.setEchoChar (ev.getSource () == checkBox2 ? '*' : '\0');
	    tf.setText (tf.getText ());
	}
    }

    
    public void actionPerformed (ActionEvent ev) {
	if (ev.getActionCommand ().equals ("beep")) {
	    Toolkit.getDefaultToolkit ().beep ();
	}
	else System.exit (0);
    }
}

class ScrollbarPanel extends Panel implements AdjustmentListener, ActionListener {
    Label label;
    Scrollbar horizontal;

    ScrollbarPanel (Frame frame) {
	super (new BorderLayout ());

	Panel center = new Panel (new GridLayout (0, 2));

	label = new Label ();
	horizontal = new Scrollbar (Scrollbar.HORIZONTAL);
	horizontal.addAdjustmentListener (this);
    
        java.awt.List list = new java.awt.List ();

	for (int i= 0; i < 16; i++)	
	    list.add ("item "+i);

	center.add (list);

	/*
	ScrollPane sp = new ScrollPane ();
	sp.add (new MemPanel ());
	center.add (sp);
	*/
	
	TextArea ta = new TextArea ();
	    
	ta.setText ("This is an example\nof a simple TextArea\nwith hard line breaks.\n01\n02\n03\n04\n05\n06\n07\n08\n09\n10\n11\n12\n13\n14\n15\n16\n17\n18\n19\n20\n");
	
	center.add (ta);
	
	Button exitB = new Button ("exit");
	exitB.addActionListener (this);
	exitB.setActionCommand ("exit");
	add ("East", exitB);

	add ("North", label);
	add ("Center", center);
	add ("South", horizontal);
	adjustmentValueChanged (null);

	validate ();
    }
    
    public void adjustmentValueChanged (AdjustmentEvent ev) {
	label.setText ("Pos h: "+horizontal.getValue ());
    }
    
    public void actionPerformed (ActionEvent e) {
	String cmd = e.getActionCommand ();
	if (cmd.equals ("exit")) 
	    System.exit (0);
    }
}

class Closer extends WindowAdapter {
    public void windowClosing (WindowEvent e) {
	System.exit (0);
    }
}

public class KawtSample extends Frame implements ActionListener {
    Dialog dialog;
    TabbedPane tabPane;

    KawtSample () {
	setTitle ("kAWT Sample v0.95");

	MenuBar menuBar = new MenuBar ();
	Menu menu = new Menu ("About");
	MenuItem mi = new MenuItem ("About kAWT");
	mi.addActionListener (this);
	menu.add (mi);
       
	menu.add (new MenuItem ("An uselsess entry"));
	menuBar.add (menu);

	menu = new Menu ("Test");

	menuBar.add (menu);
	menu.add (new MenuItem ("Test 1"));
	menu.add (new MenuItem ("Test 2"));
	menu.add (new MenuItem ("Test 3"));
	setMenuBar (menuBar);


	tabPane = new TabbedPane();
	tabPane.addTab ("Layout", new LayoutPanel (this));
	tabPane.addTab ("Color", new MemPanel ());
	tabPane.addTab ("Scroll", new ScrollbarPanel (this));
	tabPane.addTab ("Misc", new MiscPanel (this));
	add ("Center", tabPane);
	
	addWindowListener (new Closer ());
	pack ();
    }
    
    public static void main (String [] argv) {
	new KawtSample ().show ();
    }

    public void actionPerformed (ActionEvent e) {
	OptionDialog.showMessageDialog 
	    (this, "Sample app, see www.kawt.de");
    } 

}






