package java.awt;

import java.awt.event.*;

abstract class Scrollable extends Component {
    
    Scrollbar vBar;
    Scrollbar hBar;
    
    int viewPortW;
    int viewPortH;



    public void paintAll (Graphics g) {

	if (!visible) return;
	// draw scrollbars

	// change g according to scrollbars and insets
	
	int x0 = 0;
	int y0 = 0;

	if (vBar != null) {
	    vBar.paint (g.create (vBar.x, vBar.y, vBar.w, vBar.h));
	    y0 = vBar.currValue;
	}

	if (hBar != null) { 
	    hBar.paint (g.create (hBar.x, hBar.y, hBar.w, hBar.h));
	    x0 = hBar.currValue;
	}

	
	g.clipRect (0, 0, viewPortW, viewPortH);
	//	g.translate (xOff, yOff);

	//	System.out.println ("sbpa childx: "+child.x+ " y: "+child.y 
	//		    +" w: "+child.w + " h: "+child.h);

	paintContent (g, x0, y0);
    }

    
    abstract void paintContent (Graphics g, int x0, int y0);

    abstract Dimension getVirtualSize ();

    

    public synchronized void doLayout () {  

	viewPortW = w;
	viewPortH = h;

	Dimension d = getVirtualSize ();

	if (d.width < viewPortW) d.width = viewPortW;
	if (d.height < viewPortH) d.height = viewPortH;

	
	// two iterations!

	//	for (int i = 0; i <2; i++) {

	if (d.height > viewPortH) {
	    if (vBar == null) {
		vBar = new Scrollbar (Scrollbar.VERTICAL);
		vBar.parent = this;
		vBar.repaintParent = true;
		vBar.setSize (vBar.getMinimumSize ());
	    }
	    vBar.maxValue = d.height - h;
	    vBar.currVisible = h;
	    vBar.blockIncrement = h;
	    vBar.unitIncrement = Toolkit.defaultTextHeight;
	    
	    vBar.x = w - vBar.w;
	    vBar.y = 0;
	    vBar.h = h;
	    
	    viewPortW = w - vBar.w;
	}
	else vBar = null;
	
	if (d.width > viewPortW) {
	    if (hBar == null) {
		hBar = new Scrollbar (hBar.HORIZONTAL);
		hBar.parent = this;
		hBar.repaintParent = true;
		hBar.setSize (hBar.getMinimumSize ());
	    }
	    hBar.maxValue = d.width - w;
	    hBar.currVisible = w;
	    hBar.blockIncrement = w;
	    hBar.unitIncrement = Toolkit.defaultTextHeight;
	    
	    hBar.y = h - hBar.h;
	    hBar.x = 0;
	    hBar.w = viewPortW;
	    
	    viewPortH = h - hBar.h;
	}
	else hBar = null;
	//	}
	
	valid = true;
    }

    
    public Component findComponentAt (int px, int py) {

	if ((!visible) || !contains (px, py)) return null;
	
	if (vBar != null) {
	    if (px > viewPortW) return vBar;
	    px += vBar.currValue;
	}
	
	if (hBar != null) {
	    if (py > viewPortH) return hBar;
	    py += hBar.currValue;
	}

	return this;
    }
}
