// TextArea.java
//
//  2000-09-07 SH repaint problem fixed
//	
//#include ..\..\license.txt
//
// kAWT version 0.95
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS
// 
//#endinclude


package java.awt;

import java.awt.event.*;
import java.util.Vector;


/** The kAWT TextArea currently does NOT support editing.
    It depends on hard line breaks and does not perform
    any word wrap. */

public class TextArea extends TextComponent {

    StringBuffer starts = new StringBuffer ();

    //    Vector content = new Vector ();
    int maxWidth = 100;
    int lineH = Toolkit.defaultTextHeight;


    ScrollManager scrollManager = new ScrollManager 
	(this, ScrollManager.BORDER_SINGLE);


    public void paintAll (Graphics g) {

	if (!visible) return;

	scrollManager.paint (g);

	int i = scrollManager.yOffset / lineH;
	int cy = Toolkit.defaultTextBaseline 
	    - (scrollManager.yOffset % lineH);
	int cx = 1 - scrollManager.xOffset;
	int lines = starts.length ()- 1;

	for (; cy < scrollManager.viewPortH + lineH && i < lines; 
	     cy += lineH) {
	    String li = getLine (i++);
	    int len = li.length ();
	    if (len > 1)
		g.drawString (li.substring (0, len-1), cx, cy);
	}
    }

    
    public synchronized void doLayout () {  
	scrollManager.doLayout (maxWidth, (starts.length ()-1) * lineH);
    }

    
    public Component findComponentAt (int px, int py) {
	return scrollManager.findComponentAt (px, py);
    }


    String getLine (int i) {

	String tmp = text.toString ();
	int p0 = starts.charAt (i);
	int p1 = starts.charAt (i+1);

	return tmp.substring (p0, p1);
    }
    

    public Dimension getPreferredSize () {
	return new Dimension (maxWidth + scrollManager.border, 
			      (starts.length () - 1) * lineH 
			      + scrollManager.border);
    }


    /** FIXME: currently, max width is not updated. */

    public void setText (String text) {

	starts = new StringBuffer ();

	int i0 = 0;

	while (true) {
	    starts.append ((char) i0);
	    int i = text.indexOf ('\n', i0);
	    if (i == -1) break;
	    i0 = i+1;
	}
	starts.append ((char) text.length ());

	super.setText (text);
    }


    public void processMouseEvent (MouseEvent me) {
	super.processMouseEvent (me);
	if (me.isConsumed ()) return;

	if (!hasFocus) 
	    requestFocus ();
	
	/*
	int cp = 0;
	int mx = me.getX () + scrollOffset;
	int w = 0;
	
	while (w < mx && cp < text.length ()) {
	    w += fontMetrics.stringWidth 
		(text.substring (cp, cp+1));
	    cp++;
	}

	if (me.getID () == me.MOUSE_PRESSED)  
	    cx0 = cp;
	    
	if (cp != caretPos || me.getID () == me.MOUSE_PRESSED) {
	    caretPos = cp;
	    repaint ();
	}
	*/
    }
}

