// ImageItem.java
//
// 2000-09-08 MK Added new Licensetext
//
//#include ..\license.txt
//
// kAWT version 0.96
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS
// 
//#endinclude


package de.kawt;

import java.awt.*;
import java.awt.image.*;

public class ImageItem extends Canvas {

    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int INVERSE = 4;

    static Image [] images = new Image [8]; 
    
    Image image;

    public ImageItem (Image image) {
	this.image = image; 
	//setPreferredSize (image.getWidth (this), image.getHeight (this));
	//	setPreferredSize (image.getWidth (), image.getHeight);
    }
    
    public void paint (Graphics g) {
	g.drawImage (image, 0, 0, this);
    }
    
    
    public static Image getImage (int type) {
	if (images [type] == null) {
	    byte [] data = null;
	    
	    switch (type) {
	    case UP: 
		data = new byte [] {
		    71,73,70,56,57,97,7,0,6,0,
		    -128,0,0,-1,-1,-1,0,0,0,44,
		    0,0,0,0,7,0,6,0,0,2,
		    10,-124,-113,-127,16,125,13,25,-116,11,
		    20,0,59};
		
		break;
	    case DOWN:
		data = new byte [] {
		    71,73,70,56,57,97,7,0,6,0,
		    -128,0,0,-1,-1,-1,0,0,0,44,
		    0,0,0,0,7,0,6,0,0,2,
		    10,-124,15,-95,27,-55,-73,80,-110,-78,
		    0,0,59};
		break;
		
	    case LEFT:
		data = new byte [] {
		    71,73,70,56,57,97,6,0,7,0,
		    -128,0,0,-1,-1,-1,0,0,0,44,
		    0,0,0,0,6,0,7,0,0,2,
		    12,-124,17,-121,105,-31,-19,-40,-110,75,
		    33,80,0,0,59};
		break;
		
	    case RIGHT: 
		data = new byte [] {
		    71,73,70,56,57,97,6,0,7,0,
		    -128,0,0,-1,-1,-1,0,0,0,44,
		    0,0,0,0,6,0,7,0,0,2,
		    12,68,-128,24,-105,-53,-26,-44,106,-49,
		    36,80,0,0,59};
		break;
		
	    case (UP|INVERSE):
		data = new byte [] {
		    71,73,70,56,57,97,7,0,6,0,
		    -128,0,0,-1,-1,-1,0,0,0,44,
		    0,0,0,0,7,0,6,0,0,2,
		    10,-116,-113,-128,1,125,13,25,-116,43,
		    20,0,59};
		break;
		
	    case (DOWN|INVERSE):
		data = new byte [] {
		    71,73,70,56,57,97,7,0,6,0,
		    -128,0,0,-1,-1,-1,0,0,0,44,
		    0,0,0,0,7,0,6,0,0,2,
		    10,-116,31,-96,11,-55,-73,80,-110,-78,
		    0,0,59};
		
		break;
		
	    case LEFT|INVERSE:
		data = new byte [] {
		    71,73,70,56,57,97,6,0,7,0,
		    -128,0,0,-1,-1,-1,0,0,0,44,
		    0,0,0,0,6,0,7,0,0,2,
		    12,-116,3,-121,105,-32,-19,-40,-110,75,
		    -95,80,0,0,59};
		break;
		
	    default:
		data = new byte [] {
		    71,73,70,56,57,97,6,0,7,0,
		    -128,0,0,-1,-1,-1,0,0,0,44,
		    0,0,0,0,6,0,7,0,0,2,
		    12,12,-126,8,-105,-53,-26,-44,106,-49,
		    -92,80,0,0,59};
	    }	
	    
	    images [type] = Toolkit.getDefaultToolkit ().createImage (data);
	}
	return images [type];
    }
}
