// TabbedPane.java
//
// 2000-09-08 MK Added new Licensetext
// 2000-08-06 MK fixed bug in remove()/add()
// 2000-05-20 SH changed package to de.kawt
// 2000-01-12 SH itemEvent impl. improved
// 1999-11-22 SH Version 0.12: event problems removed
// 1999-11-07 SH Version number 0.11 released
//		  - ItemListener for select/deselect added
// 		  - getSelectedIndex() added 
//
//#include ..\license.txt
//
// kAWT version 0.96
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS
// 
//#endinclude


package de.kawt;

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;


class TabControl extends Canvas implements MouseListener {
    
    int sel;  // selected
    boolean mono = SystemColor.control.equals (Color.white);
    
    Vector titles = new Vector ();
    TabbedPane tp;
    
    TabControl (TabbedPane _tp) {
	tp = _tp;
	setBackground (SystemColor.control);
	addMouseListener (this);
    }
    
    
    public void add (String title) {
	titles.addElement (title);
	if (sel < 0)
	    sel = 0;
	repaint ();
    }
    
    
    public void remove (int index) {
	titles.removeElementAt (index);
	if (sel >= index) 
	    sel--;
	repaint ();
    }
    
    
    public Dimension getMinimumSize () {
	FontMetrics m = getFontMetrics (getFont ());
	return new Dimension (160, m.getHeight () + (mono ? 5 : 8));
    }
    
    
    public Dimension getPreferredSize () {
	return getMinimumSize ();
    }
    
    
    public void drawTab (Graphics g, int x, int y, int w, int h, 
			 int dt, String text) {
	if (mono) {
	    g.setColor (Color.black);
	    g.drawLine (x, y+h-1, x, y+2);
	    g.drawLine (x, y+2, x+2, y);
	    g.drawLine (x+2, y, x+w-2, y);      
	    g.drawLine (x+w-2, y, x+w, y+2);  // one pixel wider than spec.
	    g.drawLine (x+w, y+2, x+w, y+h-1);
	    g.drawString (text, x + 5 + dt, y + h - 5);
	}
	else {
	    g.setColor (Color.white);
	    g.drawLine (x,   y+h-1, x,   y+2);     // ganz links
	    g.drawLine (x+1, y+h-1, x+1, y+1);
	    
	    g.drawLine (x+3, y,   x+w-3, y);       // ganz oben
	    g.drawLine (x+2, y+1, x+w-2, y+1);
	    
	    g.setColor (Color.black);           // ganz rechts
	    g.drawLine (x+w-1, y+2, x+w-1, y+h-1); 
	    
	    g.setColor (Color.gray);
	    g.drawLine (x+w-2, y+1, x+w-2, y+h-2); 
	    
	    g.setColor (SystemColor.controlText);
	    g.drawString (text, x + 5 + dt, y + h - 8);
	}
    }
    
    public void paint(Graphics g) {
	
	int overlap = mono ? 0 : 2;
	int ofs = overlap;
	int selOfs = ofs;
	int selW = 0;
	
	FontMetrics metrics = g.getFontMetrics();
	
	int h = getSize ().height;
	
	// by MK
	if (titles.size () > 0) { 
	    for (int i = 0; i < titles.size(); i++) {
		String title = (String) titles.elementAt (i);
		int w = metrics.stringWidth (title) + 10;           
		
		if (i == sel) {
		    selOfs = ofs;
		    selW = w;
		}
		else 
		    drawTab (g, ofs, 2, w, h, 0, title);
		ofs += w;
	    }
	    
	    drawTab (g, selOfs-overlap, 0, 
		     selW+overlap+overlap, h, overlap, 
		 (String) titles.elementAt (sel));
	    
	    if (!mono) {
		g.setColor (Color.white);
		g.drawLine (0, h-2, selOfs-1, h-2);
		
		g.drawLine (selOfs + selW+2, h-2, 
			    getSize ().width, h-2);
	    }
	    
	    g.drawLine (0, h-1, selOfs-1, h-1);
	    g.drawLine (selOfs + selW+1, h-1, 
			getSize ().width, h-1);
	}
    }
    
    public void mouseClicked (MouseEvent e) {} 
    public void mouseEntered (MouseEvent e) {}
    public void mouseExited (MouseEvent e) {}
    public void mousePressed(MouseEvent e) {}
    
    public void mouseReleased(MouseEvent me) {
	
	int xofs = 0;
	int mx = me.getX ();
	
	Graphics g = getGraphics();
	if (g == null) return;
	
	FontMetrics fm = g.getFontMetrics();
	
	for (int i = 0; i < titles.size(); i++) {
	    
	    int nextOfs = xofs + 10 + 
		fm.stringWidth ((String) titles.elementAt(i));
	    
	    if (mx >= xofs && mx < nextOfs) { 
		tp.setSelectedIndex (i);
		break;
	    }
	    xofs = nextOfs;
	}
    }
}



public class TabbedPane extends Panel implements ItemSelectable {
    
    CardLayout cardLayout;
    Panel mainPanel;
    TabControl tabControl;
    ItemListener itemListener;
    
    public TabbedPane() {
	super (new BorderLayout ());
	
	cardLayout = new CardLayout();
	mainPanel = new Panel (cardLayout);
	tabControl = new TabControl (this);
	
	add ("North", tabControl);
	add ("Center", mainPanel);
    }
    
    
    public void addItemListener (ItemListener l) {
	if (itemListener != null) 
	    throw new RuntimeException ("Too Many Listeners");
	
	itemListener = l;
    }
    
    /**   
     * Adds a component represented by a title to this tabbedpane.
     */
    
    public void addTab (String title, Component component) {
	mainPanel.add (title, component);
	tabControl.add (title);
    }
    
    
    /**
     * Returns the currently selected index for this tabbedpane.
     */
    
    public int getSelectedIndex () {
	return tabControl.sel;
    }
    
    /**
     * Sets the selected index for this tabbedpane and displays corresponding component. 
     */
    
    
    public Object [] getSelectedObjects () {
	Object [] res = new Object [] {mainPanel.getComponent (tabControl.sel)};
	return res;
    }
    
    
    public void setSelectedIndex (int index) {
	int oldsel = tabControl.sel;
	
	if (index >= 
	    0 && index < tabControl.titles.size() 
	    && index != tabControl.sel) {
	    
	    tabControl.sel = index;
	    
	    if (itemListener != null) 
		itemListener.itemStateChanged 
		    (new ItemEvent 
			(this, ItemEvent.ITEM_STATE_CHANGED, 
			 mainPanel.getComponent (oldsel), 
			 ItemEvent.DESELECTED)); 
	    
	    
	    cardLayout.show 
		(mainPanel, (String) tabControl.titles.elementAt 
		 (tabControl.sel));
	    
	    tabControl.repaint ();
	    
	    if (itemListener != null)
		itemListener.itemStateChanged 
		    (new ItemEvent 
			(this, ItemEvent.ITEM_STATE_CHANGED, 
			 mainPanel.getComponent (tabControl.sel), 
			 ItemEvent.SELECTED));
	}
    }
    
    
    public void removeItemListener (ItemListener l) {
	if (itemListener == l) itemListener = null;
    }
    
    
    public void removeTab (int index) {
	mainPanel.remove (mainPanel.getComponent (index));
	tabControl.remove (index);
    }
}











