// Component.java
//
// 2000-09-08 MK Added new Licensetext
// 2000-09-06 SH Changed indexOf for J9 compatibility
// 2000-08-08 SH changed getMin/PrefSize defaulting
// 2000-06-18 SH changed parent to Component for simplified 
//            implementation of scrolling
// 2000-05-20 SH improved repaint mechanism
// 2000-05-18 SH visible check added to getGraphics
// 2000-05-15 SH made getGraphics "ScrollPane-aware" 
// 2000-05-01 SH background / foreground added
// 2000-04-09 SH improved getGraphics 
// 1999-11-22 Version 0.12 getSize () added
// 1999-11-07 Version number 0.11 released
//             - internal variables width and height
//	         changed to w and h
//
//#include ..\..\license.txt
//
// kAWT version 0.96
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS
// 
//#endinclude


package java.awt;

import java.util.Vector;
import java.awt.event.*;
import java.awt.image.*;

/** Important Limitations:
 *
 *   <ul>
 *   <li>Only one listener of each type is allowed</li>
 *   <li>Many methods are still missing</li>
 *   <ul>
 *
 *   Many events are not passed through the processXXXEvent-Methods
 *   but delivered directly to the registered listener. 
 *
 */

public abstract class Component implements ImageObserver {

    int x;
    int y;
    int w;
    int h;

    int minW = -1;
    int minH = -1;

    boolean enabled = true;
    boolean visible = true;
    boolean hasFocus = false;
    boolean valid = false;
    
    Component parent;
    
    MouseListener mouseListener;
    MouseMotionListener mml;
    KeyListener keyListener;
    Dimension minimumSize;
    
    FontMetrics fontMetrics = 
	FontMetrics.defaultFontMetrics; // contains back pointer to font!!!

    Color background = Color.white;
    Color foreground = Color.black;
    
    public Component () {}
  
    public void addMouseListener (MouseListener l) {
	if (mouseListener != null)
	    throw new TooManyListenersException ();
	
	mouseListener =  l;
    }

    public void addMouseMotionListener (MouseMotionListener l) {
	if (mml != null) 
	   throw new TooManyListenersException ();

	mml = l;
    }


    public void addKeyListener (KeyListener l) {
	if (keyListener != null)
	    throw new TooManyListenersException (); 
	
	keyListener =  l;
    }
    
    
    public Component findComponentAt (int px, int py) {
	return (visible && contains (px, py)) ? this : null; 
    }


    public Rectangle getBounds () {
	return new Rectangle (x, y, w, h);
    }


    /** return null if not visible */
    
    public Point getLocationOnScreen () {
	
	// avoid recursion in order to save stack space...
	
	int sx = x;
	int sy = y;
	
	Component current = this;

	while (current.parent != null) {
	    current = current.parent;
	    if (!current.visible) return null;
	    sx += current.x;
	    sy += current.y;
	} 
	
	if (!(current instanceof Window)) return null;

	return new Point (sx, sy);
    }


    public Font getFont () {
	return fontMetrics.font;
    }

	   
    public FontMetrics getFontMetrics (Font font) {
	return new FontMetrics (font);
    }

 
    public Graphics getGraphics () {

	if (!visible) return null;

	int sx = x;
	int sy = y;

	Component current = this;
	Graphics g = new Graphics ();
	
	while (current.parent != null) {
	    current = current.parent;
	    if (!current.visible) return null;
	    if (current instanceof ScrollPane) {
		ScrollPane sp = (ScrollPane) current;
		Point p = sp.getLocationOnScreen ();
		if (p == null) return null;
		g.clipRect (p.x, p.y, 
			    sp.scrollManager.viewPortW, 
			    sp.scrollManager.viewPortH);
	    }
	    sx += current.x;
	    sy += current.y;
	}

	if (!(current instanceof Window)) return null;

	g.translate (sx, sy);
	g.clipRect (0, 0, w, h);
	
	// substract all windows in front of the current:
	// getWindow, getFrame, ...
	
	Window window = (Window) current;
	Frame frame = window.owner;
	
	int i0 = 0;

	if (frame != window) {
	    // changes for J9 compatibility
 	    i0 = frame.windows.indexOf (window, 0) + 1;
	    // end of J9 changes
	    
	    // before J9 changes
	    //i0 = frame.windows.indexOf (window) + 1;
	    if (i0 == 0) return null;
	}
	    
	for (int i = i0; i < frame.windows.size (); i++) 
	    g._sub ((Window) frame.windows.elementAt (i));
	

	return g;
    }

    public Dimension getMaximumSize () {
	return new Dimension (32767, 32767);
    }
	

    public Dimension getSize () {
	return new Dimension (w, h);
    }
    
    
    public int getX() {
	return x;
    }

    
    public int getY() {
	return y;
    }

    
    public int getWidth() {
	return w;
    }

    
    public int getHeight() {
	return h;
    }
    
    
    public Dimension getPreferredSize () {
	return getMinimumSize ();
    }
    
    
    public Dimension getMinimumSize () {
	return new Dimension 
	    (minW == -1 ? w : minW, 
	     minH == -1 ? h : minH);
    }


    public boolean contains (int x, int y) {
	return x >= 0 && x <= w && y >= 0 && y <= h;
    }
  
    
    void doLayout () {  
	valid = true;
    }
    

    public Container getParent () {
	return (parent instanceof Container) ? ((Container) parent) : null;
    }


    //public boolean imageUpdate (Image img, int infoflags, int x, int y, int width, int height) {
    //return false;
    //}
    

    public void invalidate () {
	valid = false;
	if (parent != null) parent.invalidate ();
    }
    

    public boolean isEnabled () {
	return enabled;
    }


    public boolean isVisible () {
	return visible;
    }

    public boolean isValid () {
	return valid;
    }


    public void setBackground (Color c) {
	if (!background.equals (c)){
	    background = c;
	    repaint ();
	}
    }

    
    public void setBounds (int x, int y, int w, int h) {
      this.x = x;
      this.y = y;
      this.w = w;
      this.h = h;
      //repaint ();
    }
    
    
    public void setEnabled (boolean b) {
	if (enabled != b) {
	    enabled = b;
	    repaint ();
	}
    }

    
    public void setForeground (Color c) {
	if (!foreground.equals (c)) {
	    foreground = c;
	    repaint ();
	}
    }

    public void setLocation (int x, int y) {
	this.x =  x;
	this.y =  y;
	//	repaint ();
    }
    

    public void setSize (int w, int h) {
	w =  w;
	h =  h;
    }
    

    public void setSize (Dimension d) {
	w =   d.width;
	h =  d.height;
    }
    
    /*
    public void setMinimumSize (Dimension d) {
	minW = d.width;
	minH = d.height;
    }
    */

    public void paint (Graphics g){
    }

    
    public void paintAll (Graphics g) {
	if (visible && g != null) paint (g);
    }
    

    public void proxyRequestFocus (Component c) {
	if (parent != null) parent.proxyRequestFocus (c);
    }


    public void requestFocus () {
	if (parent != null) parent.proxyRequestFocus (this); 
    }


    public void update (Graphics g) {
	g.setColor (background);
	g.fillRect (0, 0, w, h);
	g.setColor (foreground);
	paintAll (g);
    }
    

    public void repaint (int x, int y, int w, int h) {
	
	Wrapper.wrapper.addRepaint (this, new Rectangle (x, y, w, h));
    }

    
    public void repaint () {
	Wrapper.wrapper.addRepaint (this, new Rectangle (0, 0, w, h));
    }


    /** Does not work because of the type cast Problem!
     *  All event sources call the specialized method 
     *  (e.g. processMouseEvent) directly
     */
    

    public void processMouseEvent (MouseEvent e) {
	if (e.getID () == MouseEvent.MOUSE_DRAGGED) {
	    if (mml != null) 
		mml.mouseDragged (e);

	    return;
	}

	if (mouseListener == null) return;
	
	switch (e.getID ()) {
	case MouseEvent.MOUSE_PRESSED: 
	    mouseListener.mousePressed (e); break;
	    
	case MouseEvent.MOUSE_RELEASED: 
	    mouseListener.mouseReleased (e); break;
	    
	case MouseEvent.MOUSE_CLICKED: 
	    mouseListener.mouseClicked (e); break;
	}
    }


    public void processKeyEvent (KeyEvent e) {
	if (keyListener == null) return;
	
	switch (e.getID ()) {
	case KeyEvent.KEY_PRESSED: keyListener.keyPressed (e); break;
	case KeyEvent.KEY_RELEASED: keyListener.keyReleased (e); break;
	case KeyEvent.KEY_TYPED: keyListener.keyTyped (e); break;
	}
    }


    public void setVisible (boolean v) {
	if (v != visible) {
	    visible = v;
	    invalidate ();
	    repaint ();
	}
    }


    public void validate () {
	valid = true;
    }

    /*
    void _validate () {
	valid = true;
    }
    */
    
    Window _getWindow () {
	Component w = this;
	while (w.parent != null) w=w.parent;

	return (Window) w;
    }
    
}
