// Dialog.java
//
// 2000-09-08 MK Added new Licensetext
// 2000-06-25 SH/MK drawRect changes (see Graphics)
// 2000-05-20 SH Modal dialogs enabled
//	
//#include ..\..\license.txt
//
// kAWT version 0.96
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS
// 
//#endinclude


package java.awt;

public class Dialog extends Window {

    String title;
    boolean modal;

    public Dialog (Frame w) {
	this (w, "", false);
	insets = new Insets (16,0,0,0);
    }

    
    public Dialog (Frame w, String t) {
	this (w, t, false);
    }

    public Dialog (Frame w, String t, boolean modal) {
	super (w);
	this.modal = modal;
	insets = new Insets (16, 4, 4, 4);
	setTitle (t);
    }


    public Dimension getMinimumSize () {
	return new Dimension 
	    (owner.w, super.getMinimumSize ().height);
    }
    

    public void paint (Graphics g) {
	
	String s = title;
	if (s == null) s = "No Title";
	
	g.setFont (g.getFont ().deriveFont (Font.BOLD));
      
	g.setColor (SystemColor.activeCaption);
	g.drawRoundRect (0, 0, w-1, h-1, 3, 3);
	g.drawRoundRect (1, 1, w-3, h-3, 2, 2);
	g.fillRect (2,2,w-4,12);
	
	g.setColor (Color.white);
	g.drawString (s, (w - g.getFontMetrics ().stringWidth (s)) / 2, 12);
    }	
    

    public void setVisible (boolean vis) {
	if (vis == visible) return;

	super.setVisible (vis);

	if (modal) {
	    if (vis) {
		KawtThread current = (KawtThread) Thread.currentThread ();
		KawtThread kawtThread = Wrapper.wrapper.kawtThread;
		
		synchronized (current) {
		
		    if (kawtThread == current) {
			Wrapper.wrapper.kawtThread = new KawtThread ();
			Wrapper.wrapper.kawtThread.start ();
			
			Wrapper.wrapper.kawtThread.save = current;
			
			// allow thread waiting in processEvent to cont.
			
			current.type = 0;
		    }
		    else  // ok, simulate boiling out but don't
			current.type = 'y';
		    
		    current.notify ();
		    
		    while (current.type != 'x') {
			try {
			    current.wait ();
			}
			catch (InterruptedException e) {}
		    }
		}
	    }
	    else {
		KawtThread thread = Wrapper.wrapper.kawtThread;
		synchronized (thread.save) {
		    thread.save.type = 'x';
		    thread.save.notify ();
		    while (thread.save.type != 'y') {
			try {
			    thread.save.wait ();
			}
			catch (InterruptedException e) {}
		    }
		}
	    }
	} 
    }

    
    public void setTitle (String t) {
	title = t;
	repaint ();
    }
}
