// KawtThread.java
//
// 2000-09-08 MK Added new Licensetext
// 2000-08-06 SH fixes for MIDP
// 2000-05-19 SH Initial version
//	
//#include ..\..\license.txt
//
// kAWT version 0.96
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS
// 
//#endinclude


package java.awt;

import java.awt.event.*;


class KawtThread extends Thread {

    Component target;
    AWTEvent event;
    int type;
    KawtThread save;
    Runnable run;
    

    public synchronized void run () {

	do {
	    try {
		wait (500);
	    }
	    catch (InterruptedException e) {}

	    try {
		switch (type) {
		case 'k': target.processKeyEvent ((KeyEvent) event); break;
		case 'm': target.processMouseEvent ((MouseEvent) event); break;
		case 'r': run.run (); // no break -> force flush!

		default: Wrapper.wrapper.flushRepaint ();
		}
	    }
	    catch (Exception e) {		
		de.kawt.OptionDialog.showMessageDialog 
		    (Wrapper.wrapper.getActiveFrame (), 
		     e.toString ());
	    }

	    if (type != 0) {
		
		if (type == 'x') type = 'y';
		else type = 0;
		notify ();
	    }
	}
	while (type != 'y');
    }


    synchronized void processEvent (int type, Component target, 
			       AWTEvent event) {
	
	this.type = type;
	this.target = target;
	this.event = event;
	
	notify ();

	do {
	    try {
		wait ();
	    }
	    catch (InterruptedException e) {
	    }
	}
	while (this.type != 0);
    }
}



