// ScrollManager.java
//
// 2000-09-08 MK Added new Licensetext
// 2000-06-22 SH implemented some border-related fixes 
// 2000-06-18 SH Created in order to be able to remove redundant
//	
//#include ..\..\license.txt
//
// kAWT version 0.96
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS
// 
//#endinclude


package java.awt;


class ScrollManager {

    static final int BORDER_NONE = 0;
    static final int BORDER_SINGLE = 2; // one pixel each side 
    static final int BORDER_SHADOW = 5; // div 2 gives upper left

    Component component;

    Scrollbar hBar;
    Scrollbar vBar;

    int viewPortW;
    int viewPortH;

    int xOffset;
    int yOffset;

    int border; 

    boolean clear;

    ScrollManager (Component component, int border) {
	this.component = component;
	this.border = border;
    }


    /** after paint, g, xOffset and yOffset are set properly */

    void paint (Graphics g) {

	int w = component.w;
	int h = component.h;

	if (border == BORDER_SHADOW) {
	    g.drawLine (2, 1, w-4, 1);
	    g.drawLine (2, h-3, w-3, h-3);
	    g.drawLine (3, h-2, w-4, h-2);
	    
	    g.drawLine (1, 2, 1, h-4);
	    g.drawLine (w-3, 2, w-3, h-3);
	    g.drawLine (w-2, 3, w-2, h-4);
	}
	else if (border == BORDER_SINGLE)
	    g.drawRect (0, 0, w-1, h-1);


	if (vBar != null) {
	    Graphics g2 = g.create (vBar.x, vBar.y, vBar.w, vBar.h);
	    if (clear) 
		g2.clearRect (0, 0, vBar.w, vBar.h);

	    vBar.paint (g2);//.create (vBar.x, vBar.y, vBar.w, vBar.h));
	    yOffset = vBar.currValue;
	}
	else yOffset = 0; // (viewPortH - child.h) / 2;

	if (hBar != null) { 
	    Graphics g2 = g.create (hBar.x, hBar.y, hBar.w, hBar.h);
	    if (clear)
		g2.clearRect (0, 0, hBar.w, hBar.h);

	    hBar.paint (g2); //.create (hBar.x, hBar.y, hBar.w, hBar.h));
	    xOffset = hBar.currValue;
	}
	else xOffset = 0; //(viewPortW - child.w) / 2;

	clear = false;

	int b = border >> 1;

	g.clipRect (b, b, viewPortW, viewPortH);
	g.translate (b, b);
		     //g.setColor (Color.black);
	//	Graphics g2 = g.create (child.x, child.y, child.w, child.h);
    }


    /** creates scrollbars if necessary */
    
    void doLayout (int virtualW, int virtualH) {

	viewPortW = component.w - border;
	viewPortH = component.h - border;

	// two iterations!

	for (int i = 0; i < 2; i++) {
	
	    if (virtualH > viewPortH) {
		if (vBar == null) {
		    clear = true;
		    vBar = new Scrollbar (Scrollbar.VERTICAL);
		    vBar.parent = component;
		    vBar.repaintParent = true;
		    vBar.setSize (vBar.getMinimumSize ());
		}
		vBar.maxValue = virtualH - viewPortH;
		vBar.currVisible = viewPortH;
		vBar.blockIncrement = viewPortH;
		vBar.unitIncrement = Toolkit.defaultTextHeight;
		
		vBar.x = component.w - vBar.w - (border >> 1);
		vBar.y = border >> 1;
		vBar.h = component.h - border;
		
		viewPortW = component.w - border - vBar.w;
	    }
	    else {
		clear |= vBar != null;
		vBar = null;
	    }

	    if (virtualW > viewPortW) {
		if (hBar == null) {
		    clear = true;
		    hBar = new Scrollbar (hBar.HORIZONTAL);
		    hBar.parent = component;
		    hBar.repaintParent = true;
		    hBar.setSize (hBar.getMinimumSize ());
		}
		hBar.maxValue = virtualW - viewPortW;
		hBar.currVisible = viewPortW;
		hBar.blockIncrement = viewPortW;
		hBar.unitIncrement = Toolkit.defaultTextHeight;
	    
		hBar.y = component.h - hBar.h - (border >> 1);
		hBar.x = border >> 1;
		hBar.w = viewPortW;
	    
		viewPortH = component.h - hBar.h - border;
	    }
	    else {
		clear |= hBar != null;
		hBar = null;
	    }
	}

	component.valid = true;
    }


    Component findComponentAt (int px, int py) {
	
	if (!component.visible || !component.contains (px, py)) return null;
	if (vBar != null && px > viewPortW) return vBar;
	if (hBar != null && py > viewPortH) return hBar;

	return component;
    }
   
}
