// TextComponent.java
//
//  2000-09-06 EchoChar added, moved some functionality here from InputLine
//  2000-08-17 Event Bug fixed	
//
//#include ..\..\license.txt
//
// kAWT version 0.96
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS
// 
//#endinclude


package java.awt;
 
import java.awt.event.*;

public class TextComponent extends Component {

    int caretPos;
    int caretPos0;
    char echoChar = 0;

    boolean editable = true;
    TextListener textListener;
    StringBuffer text = new StringBuffer ();


    /** internal method, fires an event and forces a repaint */

    void changed () {
	if (textListener != null)
	    textListener.textValueChanged 
		(new TextEvent 
		    (this, TextEvent.TEXT_VALUE_CHANGED));
    
	repaint ();
    }

    /** Caution: In contrast to the AWT, KAWT supports 
     *	only one TextListener! 
     */

    public void addTextListener (TextListener tl) {
	if (textListener != null) 
	    throw new TooManyListenersException ();
	
	textListener = tl;
    }


    public int getCaretPosition () {
	return getSelectionStart ();
    }


    public String getSelectedText () {
	return getText ().substring (getSelectionStart (), getSelectionEnd ());
    }


    public int getSelectionStart () {
	return caretPos < caretPos0 ? caretPos : caretPos0;
    }
	
	
    public int getSelectionEnd () {
	return caretPos > caretPos0 ? caretPos : caretPos0;
    }
		

    public void drawLine (Graphics g, int x0, int y0, int p0, int p1) {
	
	String line = text.toString ().substring (p0, p1);
	int len = line.length ();

	if (len > 0 && line.charAt (len-1) < ' ')
	    line = line.substring (0, --len);
	    
	if (echoChar != 0) {
	    StringBuffer sb = new StringBuffer ();
	    for (int i = 0; i < len; i++) 
		sb.append (echoChar);
	    
	    line = sb.toString ();
	} 


	boolean cursor = false;
	int lh = fontMetrics.getHeight ();
	int ly = y0+lh-1;
	int ty = y0 + fontMetrics.getAscent ();
	String s;
	int cursorX = 0;

	g.setColor (Color.white);
	    
	if (hasFocus) {	
	    int toBlack = getSelectionStart () - p0;
	    int toWhite = getSelectionEnd () - p0;
	    if (toBlack < 0) toBlack = 0;
	    else if (toBlack > len) toBlack = len;
	    else cursor = true;
	    
	    if (toWhite < 0) toWhite = 0;
	    else if (toWhite > len) toWhite = len;
	    
	    // white
	
	    s = line.substring (0, toBlack);
	    int tw = fontMetrics.stringWidth (s);

	    g.fillRect (x0, y0, tw, lh-1);
	    g.setColor (Color.gray);
	    g.drawLine (x0, ly, x0 + tw, ly);
	    g.setColor (Color.black);
	    g.drawString (s, x0, ty);

	    // black
	    
	    x0 += tw;
	    s = line.substring (toBlack, toWhite);
	    tw = fontMetrics.stringWidth (s);
	    cursorX = x0;
	    cursor &= tw == 0;
	    
	    g.fillRect (x0, y0, tw, lh);
	    g.setColor (Color.white);
	    g.drawString (s, x0, ty);
	    
	    // white

	    x0 += tw;
	    s = line.substring (toWhite, len);
	}
	else
	    s = line;

	//int tw = fontMetrics.stringWidth (s);

	g.fillRect (x0, y0, w-x0, lh-1);
	g.setColor (Color.gray);
	g.drawLine (x0, ly, w, ly);
	g.setColor (Color.black);
	g.drawString (s, x0, ty);

	if (cursor) 
	    g.fillRect (cursorX == 0 ? 0 : cursorX-1, y0, 2, lh);
    }


    public String getText () {
	return text.toString ();
    }


    public boolean isEditable () {
	return editable;
    }

    /*
    public void processTextEvent (TextEvent te) {
	if (textListener != null) 
	    textListener.textValueChanged (te);
    }
    */
    
    public void removeTextListener (TextListener tl) {
	textListener = null;
    }


    public void select (int start, int end) {
	caretPos0 = start;
	caretPos = end;
	repaint ();
    }


    public void selectAll () {
	caretPos0 = 0;
	caretPos = getText ().length ();
	repaint ();
    }
	

    public void setEditable (boolean ed) {
	if (ed != editable) {
	    editable = ed;
	    repaint ();
	}
    }


    public void setCaretPosition (int cp) {
	if (cp < 0) cp = 0;
	if (cp > getText ().length ()) cp = getText ().length ();
	
	if (caretPos != cp || caretPos0 != cp) {
	    caretPos = cp;
	    caretPos0 = cp;
	    repaint ();
	}
    }


    public void setSelectionStart (int i) {
	caretPos0 = i;
    }


    public void setSelectionEnd (int i) {
	caretPos = i;
    }
    

    public void setText (String newText) {

	text = new StringBuffer (newText);

	if (caretPos > newText.length () || caretPos0 > newText.length ()) {
	    setCaretPosition (newText.length ());
	}
	
	repaint ();
    }   


}

    
