// TextField.java
//
//  2000-09-07 Repaint problem fixed
//  2000-08-17 Event Bug fixed
//  2000-07-24 Bugfix: changed ke. to KeyEvent. in processEvent
//  2000-06-23 _setText added, moved some methods 
//             to/from TextComponent (for TextArea impl. simplification)
//
//#include ..\..\license.txt
//
// kAWT version 0.96
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS
// 
//#endinclude


package java.awt;

import java.awt.event.*;

/** Limitations
    <ul>
    <li>The caret blinking is currently disabled because of often system 
    crashes when running threads
    <li>ActionEvents are not sent (but TextEvents)
    </ul>
*/

public class TextField extends TextComponent {
    
    int minW;
    static final int minH = 12;
    int scrollOffset = 0;

    
    public TextField () {
	this ("", 10);
    }
    
    public TextField (int cols) {
	this ("", cols);
    }
    

    public TextField (String s) {
	this (s, 10);
    }



    public TextField (String text, int cols) {
	h = minH;
	minW = 7*cols;
	w = minW;
	setText (text);
    }

    
    public boolean echoCharIsSet () {
	return echoChar != 0; 
    }


    public char getEchoChar () {
	return echoChar;
    }

    
    public Dimension getMinimumSize () {
	return new Dimension (minW, minH);
    }


    public void paint(Graphics g) {

	drawLine (g, 
		  0, (h - fontMetrics.getHeight ()) / 2, 
		  0, text.length ());

	/*

	int middle = h/2;
	int scrCaretPos = 0;
	
	String tmp = text.toString ();
	
	if (echoChar != 0) {
	    StringBuffer sb = new StringBuffer ();
	    for (int i = 0; i < text.length (); i++) {
		sb.append (echoChar);
	    }
	    tmp = sb.toString ();
	} 
	
	if (hasFocus) {
	    Point los = getLocationOnScreen (); 
	    
	    scrCaretPos = fontMetrics.stringWidth 
		(tmp.substring (0, caretPos));
	    
	    if (scrCaretPos - scrollOffset > w 
		|| scrCaretPos - scrollOffset < 0) { 
		if (scrCaretPos < w) scrollOffset = 0;
		else scrollOffset = scrCaretPos - w / 2;
	    }
	    // Caret.caret.setPosition 
	    // (los.x + scrCaretPos - scrollOffset, los.y+middle-5);
	    
	}
	else scrollOffset = 0;
		
	g.drawString (tmp, -scrollOffset, middle+5);
	
	if (editable) {
	    g.setColor (Color.gray);
	    g.drawLine (0, middle+5, w, middle+5);
	}

	if (hasFocus) {
	    int scrCaretPos0 = fontMetrics.stringWidth 
		(tmp.substring (0, caretPos0));
	    
	    g.setColor (Color.black);
	    g.setXORMode (Color.black);

	    int cw = scrCaretPos - scrCaretPos0;
	    if (cw < 0) cw = -cw;
	    if (cw < 2) cw = 2;

	    if (scrCaretPos0 < scrCaretPos)
		g.fillRect (scrCaretPos0-scrollOffset, middle-5, 
			    cw, 10); 
	    else
		g.fillRect (scrCaretPos-scrollOffset, middle-5,
			    cw, 10); 
	}

	*/
    }
    

    public void processMouseEvent (MouseEvent me) {
	
	if (!hasFocus) 
	    requestFocus ();
	
	int cp = 0;
	
	int mx = me.getX () + scrollOffset;
	int w = 0;
	
	String tmp = text.toString ();

	while (w < mx && cp < text.length ()) {
	    w += fontMetrics.stringWidth 
		(tmp.substring (cp, cp+1));
	    cp++;
	}

	if (me.getID () == me.MOUSE_PRESSED)  
	    caretPos0 = cp;
	    
	if (cp != caretPos || me.getID () == me.MOUSE_PRESSED) {
	    caretPos = cp;
	    repaint ();
	}
    }
    
    
//#ifdef j9
//#     public void processKeyEvent (KeyEvent ke) {
//# 
//# 	super.processKeyEvent (ke);
//# 	if (ke.isConsumed ()) return;
//# 
//# 	int p0 = getSelectionStart ();
//# 	int p1 = getSelectionEnd ();
//# 
//# 	caretPos = p0;
//# 	caretPos0 = p0;
//# 
//# 	if (ke.getID () == ke.KEY_TYPED) {
//# 
//# 	    if (!editable) return;
//# 
//# 	    caretPos++;
//# 	    caretPos0 = caretPos;
//# 
//# 	    int len = text.length();
//# 	    StringBuffer newText = new StringBuffer(len - (p1-p0) + 1);
//# 	    int i;
//# 	    for (i = 0; i < p0; i++)
//# 		newText.append(text.charAt(i));
//# 	    newText.append(ke.getKeyChar());
//# 	    for (i = p1; i < len; i++)
//# 		newText.append(text.charAt(i));
//# 	    text = newText;
//# 
//# 	    /*
//# 	    setText (text.substring (0, p0)
//# 		     + ke.getKeyChar ()
//# 		     + text.substring (p1, text.length ()));  */
//# 
//# 	    changed ();
//# 	}
//# 	else {
//# 	    int kc = ke.getKeyCode ();
//# 	    switch (kc) {
//# 	    case KeyEvent.VK_LEFT:
//# 		setCaretPosition (p0-1);
//# 		break;
//# 
//# 	    case KeyEvent.VK_RIGHT:
//# 		setCaretPosition (p1+1);
//# 		break;
//# 
//# 	    case KeyEvent.VK_BACK_SPACE:
//# 		if (caretPos > 0) caretPos--;
//# 		caretPos0 = caretPos;
//# 
//# 		if (p0 <= 1)
//# 		    text = deleteFromStringBuffer(text, 0, p1);
//# 		else
//# 		    text = deleteFromStringBuffer(text, p0-1, p1);
//# 
//# 		changed ();
//# 		break;
//# 	    default:
//# 		text.append (ke.getKeyCode ());
//# 		changed ();
//# 	    }
//# 	}
//#     }
//# 
//#    static final private StringBuffer deleteFromStringBuffer (StringBuffer text,
//# 							     int start,
//# 							     int end) {
//#        int len = text.length();
//#        StringBuffer sb = new StringBuffer(len - (end-start));
//#        int i;
//# 
//#        for (i = 0; i < start; i++)
//# 	   sb.append(text.charAt(i));
//# 
//#        for (i = end; i < len; i++)
//# 	   sb.append(text.charAt(i));
//# 
//#        return sb;
//#     }
//# 
//# 
//# 
//#else
    public void processKeyEvent (KeyEvent ke) {

	super.processKeyEvent (ke);
	if (ke.isConsumed ()) return;

	int p0 = getSelectionStart ();
	int p1 = getSelectionEnd ();

	caretPos = p0;
	caretPos0 = p0;

	if (ke.getID () == ke.KEY_TYPED) {

	    if (!editable) return;

	    caretPos++;
	    caretPos0 = caretPos;

	    text.delete (p0, p1);
	    text.insert (p0, ke.getKeyChar ());
	    /*
	    setText (text.substring (0, p0)
		     + ke.getKeyChar ()
		     + text.substring (p1, text.length ()));  */

	    changed ();
	}
	else {
	    int kc = ke.getKeyCode ();
	    switch (kc) {
	    case KeyEvent.VK_LEFT:
		setCaretPosition (p0-1);
		break;

	    case KeyEvent.VK_RIGHT:
		setCaretPosition (p1+1);
		break;

	    case KeyEvent.VK_BACK_SPACE:
		if (caretPos > 0) caretPos--;
		caretPos0 = caretPos;

		if (p0 <= 1)
		    text.delete (0, p1);
		else
		    text.delete (p0-1, p1);

		changed ();
		break;
	    default:
		text.append (ke.getKeyCode ());
		changed ();
	    }
	}
    }

//#endif


    public void setEchoChar (char c) {
	echoChar = c;
	repaint ();
    }

    public void update (Graphics g) {
	paint (g);
    }


}






