// Window.java
//
// 2000-09-08 MK Added new Licensetext
// 2000-05-25 SH Immediate repaint implemented (because of modal windows)
// 2000-04-10 SH Fixed repaint problems for tiled windows   
//	
//#include ..\..\license.txt
//
// kAWT version 0.96
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS
// 
//#endinclude


package java.awt;

import java.awt.event.*;
import java.util.Vector;



public class Window extends Container {

    Frame owner;
    Component focus;
    boolean isMenu = false; // close if clicking elsewhere


    public Window (Frame f) {
	super (new BorderLayout ());
	
	owner = f;
	visible = false;
    }

    
    /** This method does not do anything and is included for
        compatibility only */

    public void addWindowListener (WindowListener l) {
    }
    

    public void dispose () {
	setVisible (false);
    }


    public Component getFocusOwner () {
	return focus;
    }

    
    public Window getOwner () {
	return owner != this ? owner : null;
    }

    /* 

    public Point getLocationOnScreen () {

	return (owner.getTopWindow () == this) ? new Point (x, y) : null;
    }
    
    */

    public Toolkit getToolkit () {
	return Toolkit.defaultToolkit;
    }


    public void pack () {
	setSize (getPreferredSize ());
	validate ();
	x = 0;
	y = owner.h - h;
    }
    
 
    public void proxyRequestFocus (Component fc) {
	if (focus != null) {
	    focus.hasFocus = false;
	    focus.repaint ();
	    
	    //  if (focus instanceof TextField)
		//Caret.caret.setVisible (false);
	}
	
	focus = fc;

	//if (focus instanceof TextField)
	    //Caret.caret.setVisible (true);

	focus.hasFocus = true;
	focus.repaint ();
    }
    
  
    public void setVisible (boolean vis) {
	if (vis == visible) return;

	if (vis) {
	    owner.windows.addElement (this);
	    visible = true;
	    repaint ();
	}
	else {
	    owner.windows.removeElement (this);
	    visible = false;

	    Graphics g = owner.getGraphics ();
	    if (g != null) {
		g.clipRect (x, y, w, h);
		owner.update (g);
		g.dispose ();
	    }

	    for (int i = 0; i < owner.windows.size (); i++) {
		Window win = (Window) owner.windows.elementAt (i);
		g = win.getGraphics ();
		if (g != null) {
		    g.clipRect (x-win.x, y-win.y, w, h); 
		    win.update (g);
		    g.dispose ();
		}
	    }
	}
    }	
    

    public void show () {
	setVisible (true);
    }
}
