// Wrapper.java
//
//  2000-08-06 SH changes for MIDP 
//  2000-07-23    Modal Dialog problem with menues fixed
//  2000-05-22 SH Repaint bug fixed
//  2000-05-19 SH KawtThread and repaint support added
//  1999-11-24    Changes for 0.14 synchronized constants with original awt
//
//#include ..\..\license.txt
//
// kAWT version 0.96
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS
// 
//#endinclude


package java.awt;

import java.io.*;
import java.awt.event.*;
import java.util.Vector;

//#ifdef kjava
class Wrapper extends com.sun.kjava.Spotlet {
//#endif
//#ifdef midp
//# 
//# public class Wrapper extends javax.microedition.lcdui.Canvas {
//#     static javax.microedition.lcdui.Image offScreen;
//#     static javax.microedition.lcdui.Graphics graphics;
//#endif
    
    static KawtThread kawtThread;
    static Wrapper wrapper;

    static Component mouseOwner;
    static int mouseOrgX;
    static int mouseOrgY;

    static Vector repaint = new Vector ();
    static Vector repaintRects = new Vector ();

//#ifdef kjava
    //de.kawt.palm.InfraredReceiver receiver = null;
//#endif

//#ifdef kjava
    Wrapper () {
	register (NO_EVENT_OPTIONS);
//#else
//#     public Wrapper (javax.microedition.midlet.MIDlet midLet) {
//# 
//# 	wrapper = this;
//# 	javax.microedition.lcdui.Display display
//# 	    = javax.microedition.lcdui.Display.getDisplay (midLet);
//# 	display.setCurrent (this);
//# 
//# 	offScreen = javax.microedition.lcdui.Image.createImage
//# 	    (getWidth (), getHeight ());
//# 
//# 	graphics = offScreen.getGraphics ();
//# 	Graphics.screenRect = new Rectangle (0, 0, getWidth (), getHeight ());
//#endif

	kawtThread = new KawtThread ();
	kawtThread.start ();
    }


    synchronized void addRepaint (Component c, Rectangle r) {
	
	if (!c.visible) return;

	int cnt = repaint.size ();

	for (int i = 0; i < cnt; i++) {

	    Component ci = (Component) repaint.elementAt (i);
	    Rectangle ri = (Rectangle) repaintRects.elementAt (i);
	    
	    if (c == ci) {
		ri.add (r);
		return;
	    }
	    if ((c instanceof Container) 
		&& ((Container) c).isAncestorOf (ci)) {
		
		do {
		    ri.x += ci.x;
		    ri.y += ci.y;
		    ci = ci.parent;
		} while (ci != c);
		
		r.add (ri);
		repaint.removeElementAt (i);
		repaintRects.removeElementAt (i);
		i--;
		cnt--;
	    }
	    else if ((ci instanceof Container)
		     && ((Container) ci).isAncestorOf (c)) {
		
		do {
		    r.x += c.x;
		    r.y += c.y;
		    c = c.parent;
		} while (c != ci);
		ri.add (r);    
		//		repaintRects.setElementAt 
		//    (new Rectangle (0, 0, ci.w, ci.h), i);

		return;
	    }
	}

	repaint.addElement (c);
	repaintRects.addElement (r);
    }

    
    public synchronized void flushRepaint () {
	
	int cnt = repaint.size ();
	
	for (int i = 0; i < cnt; i++) { 

	    Component c = (Component) repaint.elementAt (i);
	    Graphics g = c.getGraphics ();
	    if (g != null) {
		Rectangle r = (Rectangle) repaintRects.elementAt (i);
		g.clipRect (r.x, r.y, r.width, r.height);
		c.update (g);
		
//#ifdef midp	
//# 	        //repaint (r.x, r.y, r.width, r.height);
//#endif
	    }
	}

	repaint.removeAllElements ();// = new Vector ();
	repaintRects.removeAllElements ();// = new Vector ();
//#ifdef midp	
//# 	if (Graphics.dirty)
//# 	    repaint ();
//#endif
    }
    

    Frame getActiveFrame () {
	int i = Frame.frames.size ();
	return i > 0 ? (Frame) Frame.frames.elementAt (i-1) : null;
    }
    
//#ifdef kjava
    public void keyDown (int keyCode) {

	Frame frame = getActiveFrame ();

	if (frame == null) return;

	Window top = frame.getTopWindow ();

	if (keyCode == com.sun.kjava.Spotlet.MENUICON) {
	    if (frame.menuBar != null) {
		if (top.isMenu) {
		    do {
			top.setVisible (false);
			top = frame.getTopWindow ();
		    }
		    while (top.isMenu);
		}
		else if (frame == top) frame.menuBar.show ();
	    }
	    return;
	}




	if (top.focus == null) return;

	if (keyCode < 31 /*|| keyCode > 128*/) {
	    switch (keyCode) {
	    case 28: keyCode = KeyEvent.VK_LEFT; break;
	    case 29: keyCode = KeyEvent.VK_RIGHT; break;
	    case PAGEDOWN: keyCode = KeyEvent.VK_PAGE_DOWN; break;
	    case PAGEUP: keyCode = KeyEvent.VK_PAGE_UP; break;

	    }

	    kawtThread.processEvent
		('k', top.focus,
		 new KeyEvent (top,
			       KeyEvent.KEY_PRESSED, 0, 0,
			       keyCode, KeyEvent.CHAR_UNDEFINED));

	}
	else
	    kawtThread.processEvent
		('k', top.focus,
		 new KeyEvent (top,
			      KeyEvent.KEY_TYPED, 0, 0,
			      KeyEvent.VK_UNDEFINED, (char) keyCode));

	flushRepaint ();
    }
//#endif 


//#ifdef kjava
    public void penDown (int x, int y) {
//#else
//#     public void pointerPressed (int x, int y) {
//#endif
 	Frame frame = getActiveFrame ();
 	if (frame == null) return;
 
 	while (true) {
 	    Window topWindow = frame.getTopWindow ();
 	    Point p = topWindow.getLocationOnScreen ();
 
 	    mouseOwner = topWindow.findComponentAt (x - p.x, y - p.y);
 
 	    if (mouseOwner != null) {
 		p = mouseOwner.getLocationOnScreen ();
 
 		mouseOrgX = p.x;
 		mouseOrgY = p.y;
 
 		kawtThread.processEvent
 		    ('m', mouseOwner,
 		     new MouseEvent (mouseOwner,
 				     MouseEvent.MOUSE_PRESSED, 0, 0,
 				     x-mouseOrgX, y-mouseOrgY, 0, false));
 
 		break;
 	    }
 	    else if (topWindow.isMenu)
 		topWindow.setVisible (false);
 	    else break;
 	}

	flushRepaint ();
     }
 
//#ifdef kjava 
    public void penUp (int x, int y) {
//#else
//#     public void pointerReleased (int x, int y) {
//#endif 
 	if (mouseOwner == null) return;
 
 	x -= mouseOrgX;
 	y -= mouseOrgY;
 
 	kawtThread.processEvent
 	    ('m', mouseOwner,
 	     new MouseEvent (mouseOwner,
 			     MouseEvent.MOUSE_RELEASED, 0, 0, x, y,
 			     0, false));
 
 
 	kawtThread.processEvent
 	    ('m', mouseOwner,
 	     new MouseEvent (mouseOwner,
 			     MouseEvent.MOUSE_CLICKED, 0, 0, x, y,
 			     0, false));

	flushRepaint ();
   }

 
//#ifdef kjava 
     public void penMove (int x, int y) {
//#else
//# 	 public void pointerDragged (int x, int y) {
//#endif
 	if (mouseOwner != null)
 	    kawtThread.processEvent
 		('m', mouseOwner,
 		 new MouseEvent (null, MouseEvent.MOUSE_DRAGGED, 0, 0,
 				 x-mouseOrgX, y-mouseOrgY, 0, false));
	flushRepaint ();
     }


//#ifdef kjava
    /*public void beamReceive (byte[] data) {
      System.out.println ("Wrapper Received <" + data.length + "> bytes of data");
      System.out.println ("Wrapper Received <" + new String (data) + ">" );
      if (com.sun.cldc.io.j2me.obex.Protocol.protocol != null)
      try {
      com.sun.cldc.io.j2me.obex.Protocol.protocol.newDatagram (data, data.length, "0.0.0.0") ;
      com.sun.cldc.io.j2me.obex.Protocol.protocol.buffer = data;
      } catch (IOException e) {
      System.out.println (e);
      }
      com.sun.cldc.io.j2me.obex.Protocol.protocol.notify ();
      Frame frame = getActiveFrame ();
      ((ActionListener)frame).actionPerformed (new ActionEvent (data, 0, "beamReceive"));
      }*/
//#endif

 

//#ifdef midp
//# 
//#     /** public for kawt-internal purposes. Do not touch! */
//# 
//#     public void paint (javax.microedition.lcdui.Graphics g) {
//# 
//# 	synchronized (Graphics.lock) {
//# 	    g.drawImage (offScreen, 0, 0,
//# 			 javax.microedition.lcdui.Graphics.TOP
//# 			 | javax.microedition.lcdui.Graphics.LEFT);
//# 	    Graphics.dirty = false;
//# 	}
//#     }
//#endif
}




