// SpotletImpl.java
//
//  2000-10-06 SH Initial Version
//
//#include ..\..\..\license.txt
//
// kAWT version 0.98
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS
// 
//#endinclude


package de.kawt.impl.kjava;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.Vector;

public class SpotletImpl extends com.sun.kjava.Spotlet {

    public SpotletImpl () {
	register (NO_EVENT_OPTIONS);

	// die eventqueue kann hier nicht zugegr werden, da dies
	// aus dem constr. von Toolkit aufger. wird...
    }


    public void keyDown (int palmCode) {

	int keyCode = KeyEvent.VK_UNDEFINED;
	char charCode = KeyEvent.CHAR_UNDEFINED;
	int type = KeyEvent.KEY_PRESSED;
	
	switch (palmCode) {
	case 8: keyCode = KeyEvent.VK_BACK_SPACE; break;
	case 10: keyCode = KeyEvent.VK_ENTER; break;
	case 28: keyCode = KeyEvent.VK_LEFT; break;
	case 29: keyCode = KeyEvent.VK_RIGHT; break;
	case PAGEDOWN: keyCode = KeyEvent.VK_PAGE_DOWN; break;
	case PAGEUP: keyCode = KeyEvent.VK_PAGE_UP; break;
	case MENUICON: keyCode = KeyEvent.VK_PROPS; break;
	default: 
	    charCode = (char) (palmCode < ' ' ? palmCode + '@' : palmCode);
	    type = KeyEvent.KEY_TYPED;
	}
	
	Toolkit.getDefaultToolkit ().getSystemEventQueue ().postEvent
	    (new KeyEvent 
		(null,
		 type, 0, 0,
		 keyCode, charCode));
    }
    
    
    public void penDown (int x, int y) {

	Toolkit.getDefaultToolkit ().getSystemEventQueue ().postEvent 
	    (new MouseEvent (null,
			     MouseEvent.MOUSE_PRESSED, 0, 0,
			     x, y, 0, false));
    }
    

    public void penUp (int x, int y) {
	EventQueue eventQueue = 
	    Toolkit.getDefaultToolkit ().getSystemEventQueue ();

	eventQueue.postEvent 
	    (new MouseEvent (null,
			     MouseEvent.MOUSE_RELEASED, 0, 0, x, y,
 			     0, false));
	
 
 	eventQueue.postEvent
 	    (new MouseEvent (null,
 			     MouseEvent.MOUSE_CLICKED, 0, 0, x, y,
 			     0, false));
    }
    
    
    public void penMove (int x, int y) {
	Toolkit.getDefaultToolkit ().getSystemEventQueue ().postEvent 
	    (new MouseEvent (null, MouseEvent.MOUSE_DRAGGED, 0, 0,
			     x, y, 0, false));
     }

}
