// BorderLayout.java
//
// 2000-09-30 SH removeLayoutComponent fixed
// 2000-09-08 MK Added new Licensetext
// 1999-11-26 SH added removeayoutComponent for 0.2      
//	
//#include ..\..\license.txt
//
// kAWT version 0.98
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS
// 
//#endinclude


package java.awt;

public class BorderLayout implements LayoutManager {

    public static final String CENTER = "Center";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String NORTH = "North";
    public static final String WEST = "West";

    Component center;
    Component south;
    Component east;
    Component north;
    Component west;

    public void addLayoutComponent (String where, Component component) {
	if (where == null) return;
	if (where.equals ("South")) south = component;
	else if (where.equals ("East")) east = component;
	else if (where.equals ("North")) north = component;
	else if (where.equals ("West")) west = component;
	else if (where.equals ("Center")) center = component;
    }


    public void layoutContainer (Container parent) {
	int wWest = -1;
	int wEast = -1;
	int hNorth = -1;
	int hSouth = -1;
	    
	int x0 = parent.insets.left;
	int y0 = parent.insets.top;
	int w0 = parent.w - parent.insets.left - parent.insets.right;
	int h0 = parent.h - parent.insets.top - parent.insets.bottom;
	
	if (north != null) {
	    hNorth = north.getMinimumSize ().height;
	    north.w = w0;
	    north.h = hNorth;
	    north.x = x0;
	    north.y = y0;
	    north.valid = false;
	}
	
	if (south != null) {
	    hSouth = south.getMinimumSize ().height;
	    south.w = w0;
	    south.h = hSouth;
	    south.x = x0;
	    south.y = parent.h - hSouth - parent.insets.bottom;
	    south.valid = false;
	}
	
	if (west != null) {
	    wWest = west.getMinimumSize ().width;
	    west.h = h0 - hNorth - hSouth - 2;
	    west.w = wWest;
	    west.x = x0;
	    west.y = y0 + hNorth + 1;
	    west.valid = false;
	} 
	
	if (east != null) {
	    wEast = east.getMinimumSize ().width;
	    east.h = h0 - hNorth - hSouth - 2; 
	    east.w = wEast;
	    east.x = w0 - wEast;
	    east.y = y0 + hNorth + 1;
	    east.valid = false;
	}
	    
	if (center != null) {
	    center.x = x0 + wWest + 1;
	    center.y = y0 + hNorth + 1;
	    center.w = w0 - wEast - wWest - 2;
	    center.h = h0 - hNorth - hSouth - 2;
	    center.valid = false;
	}
    }
	

    public Dimension minimumLayoutSize (Container parent) {
	int wMin = 0;
	int hMin = 0;
	
	if (west != null) {
	    Dimension d = west.getMinimumSize ();
	    wMin += d.width + 1;
	    hMin = d.height;
	} 
	if (east != null) { 
	    Dimension d = east.getMinimumSize ();
	    wMin += d.width + 1;
	    if (hMin < d.height) hMin = d.height;
	}
	
	if (center != null) {
	    Dimension d = center.getMinimumSize ();
	    wMin += d.width;
	    if (hMin < d.height) hMin = d.height;
	}
	    
	if (north != null) {
	    Dimension d = north.getMinimumSize ();
	    hMin += d.height + 1;
	    if (wMin < d.width) wMin = d.width;
	}
	if (south != null) {
	    Dimension d = south.getMinimumSize ();
	    hMin += d.height + 1;
	    if (wMin < d.width) wMin = d.width;
	}
	

	return new Dimension 
	    (wMin + parent.insets.left + parent.insets.right, 
	     hMin + parent.insets.top + parent.insets.bottom); 
    }
    
    public void removeLayoutComponent (Component component) {
	if (component == south) south = null;
	else if (component == east) east = null;
	else if (component == north) north = null;
	else if (component == west) west = null;
	else if (component == center) center = null;
    } 
}



