// Wrapper.java
//
//  2000-08-06 SH changes for MIDP 
//  2000-07-23    Modal Dialog problem with menues fixed
//  2000-05-22 SH Repaint bug fixed
//  2000-05-19 SH KawtThread and repaint support added
//  1999-11-24    Changes for 0.14 synchronized constants with original awt
//
//#include ..\..\license.txt
//
// kAWT version 0.98
//
// Copyright (C) 1999-2000 by Michael Kroll & Stefan Haustein GbR, Essen
//
// Contact: kawt@kawt.de
// General Information about kAWT is available at: http://www.kawt.de
//
// Using kAWT for private and educational and in GPLed open source
// projects is free. For other purposes, a commercial license must be
// obtained. There is absolutely no warranty for non-commercial use.
//
//
// 1. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO
//    WARRANTY FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE
//    LAW.  EXCEPT WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT
//    HOLDERS AND/OR OTHER PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT
//    WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
//    NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//    FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS TO THE
//    QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
//    PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
//    SERVICING, REPAIR OR CORRECTION.
//   
// 2. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN
//    WRITING WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY
//    MODIFY AND/OR REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE
//    LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL,
//    INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR
//    INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED TO LOSS OF
//    DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU
//    OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY
//    OTHER PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN
//    ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//   
//    END OF TERMS AND CONDITIONS
// 
//#endinclude


package java.awt;

import java.io.*;
import java.awt.event.*;
import java.util.Vector;

//#ifdef kjava
class Wrapper extends com.sun.kjava.Spotlet {
//#endif
//#ifdef midp
//# 
//# public class Wrapper
//#     extends javax.microedition.lcdui.Canvas
//#     implements javax.microedition.lcdui.CommandListener {
//# 
//#     static javax.microedition.lcdui.Image offScreen;
//#     static javax.microedition.lcdui.Graphics graphics;
//#     static String cmdName;
//#     static javax.microedition.lcdui.Command command;
//#endif
    
    static Wrapper wrapper;

    static KawtThread kawtThread;
    static Component mouseOwner;
    static int mouseOrgX;
    static int mouseOrgY;

    static Vector repaint = new Vector ();
    static Vector repaintRects = new Vector ();

    /** for the new window and repaint mechanism

        1. replace frames and windows by this 
           "windows" vector (stack), containing
	   all (!) windows (not just independent). 
	   If a windows is brought to front, all 
	   "owned" windows are brought
	   to front, too

	2. simplify repaint mechanism by moving
	   a simple dirty region to the windows

	3. simplify graphics  

    */

    static Vector windows = new Vector ();

//#ifdef kjava
    //de.kawt.palm.InfraredReceiver receiver = null;
//#endif

//#ifdef kjava
    Wrapper () {
	register (NO_EVENT_OPTIONS);
//#else
//#     public Wrapper (javax.microedition.midlet.MIDlet midLet) {
//# 
//# 	wrapper = this;
//# 	javax.microedition.lcdui.Display display
//# 	    = javax.microedition.lcdui.Display.getDisplay (midLet);
//# 	display.setCurrent (this);
//# 
//# 	offScreen = javax.microedition.lcdui.Image.createImage
//# 	    (getWidth (), getHeight ());
//# 
//# 	graphics = offScreen.getGraphics ();
//# 	Toolkit.scrW = getWidth ();
//# 	Toolkit.scrH = getHeight ();
//# 
//# 	addCommand
//# 	    (new javax.microedition.lcdui.Command
//# 		("Menu", javax.microedition.lcdui.Command.SCREEN, 0));
//# 
//# 	setListener (this);
//#endif
	kawtThread = new KawtThread ();
	kawtThread.start ();
    }


    public synchronized void flushRepaint () {

	Window win = getTopWindow ();
	if (win != null) win.flushRepaint ();

//#ifdef midp
//# 
//# 	String name = null;
//# 
//# 	if (win instanceof Frame) {
//# 	    Frame frame = (Frame) win;
//# 	    name = frame.title;
//# 	    if (name == null && frame.menuBar != null) name = "Menu";
//# 	}
//# 
//# 	if ((name == null && cmdName != null)
//# 	    || name != null && !name.equals (cmdName)) {
//# 
//# 	    if (command != null) {
//# 		removeCommand (command);
//# 		command = null;
//# 		cmdName = null;
//# 	    }
//# 
//# 	    if (name != null) {
//# 		cmdName = name;
//# 
//# 	    }
//# 	}
//# 
//# 	if (Graphics.dirty)
//# 	    repaint ();
//#endif
    }	

    /*
	int cnt = repaint.size ();
	
	for (int i = 0; i < cnt; i++) { 

	    Component c = (Component) repaint.elementAt (i);
	    Graphics g = c.getGraphics ();
	    if (g != null) {
		Rectangle r = (Rectangle) repaintRects.elementAt (i);
		g.clipRect (r.x, r.y, r.width, r.height);
		c.update (g);
		
//#ifdef midp	
//# 	        //repaint (r.x, r.y, r.width, r.height);
//#endif
	    }
	}

	repaint.removeAllElements ();// = new Vector ();
	repaintRects.removeAllElements ();// = new Vector ();
//#ifdef midp	
//# 	if (Graphics.dirty)
//# 	    repaint ();
//#endif
    }
    */


    /*
    Frame getActiveFrame () {
	int i = Frame.frames.size ();
	return i > 0 ? (Frame) Frame.frames.elementAt (i-1) : null;
    }
    */

    
    static Window getTopWindow () {
	int sz = windows.size ();
	return sz == 0 ? null : (Window) windows.elementAt (sz - 1);
    }



//#ifdef kjava
    public void keyDown (int keyCode) {

	Window top = getTopWindow ();
	Frame frame = top.owner;

	if (keyCode == com.sun.kjava.Spotlet.MENUICON) {
	    if (top.isMenu) {
		do {
		    top.setVisible (false);
		    top = getTopWindow ();
		}
		while (top.isMenu);
	    }
	    else if (top instanceof Frame && ((Frame) top).menuBar != null)
		((Frame) top).menuBar.show ();

	    return;
	}

	if (top.focus == null) return;

	if (keyCode < 31 /*|| keyCode > 128*/) {
	    switch (keyCode) {
	    case 28: keyCode = KeyEvent.VK_LEFT; break;
	    case 29: keyCode = KeyEvent.VK_RIGHT; break;
	    case PAGEDOWN: keyCode = KeyEvent.VK_PAGE_DOWN; break;
	    case PAGEUP: keyCode = KeyEvent.VK_PAGE_UP; break;

	    }

	    kawtThread.processEvent
		('k', top.focus,
		 new KeyEvent (top,
			       KeyEvent.KEY_PRESSED, 0, 0,
			       keyCode, KeyEvent.CHAR_UNDEFINED));

	}
	else
	    kawtThread.processEvent
		('k', top.focus,
		 new KeyEvent (top,
			      KeyEvent.KEY_TYPED, 0, 0,
			      KeyEvent.VK_UNDEFINED, (char) keyCode));

	flushRepaint ();
    }
//#else
//# 
//#     public void keyPressed (int keyCode) {
//# 
//#  	Window top = getTopWindow ();
//# 
//#  	if (top.focus == null) return;
//# 
//#  	if (keyCode < 31 /*|| keyCode > 128*/) {
//#  	    switch (keyCode) {
//# 	    case -1:
//#  	    case UP: keyCode = KeyEvent.VK_UP; break;
//# 	    case -2:
//#  	    case DOWN: keyCode = KeyEvent.VK_DOWN; break;
//# 	    case -3:
//#  	    case LEFT: keyCode = KeyEvent.VK_LEFT; break;
//# 	    case -4:
//#  	    case RIGHT: keyCode = KeyEvent.VK_RIGHT; break;
//# 
//#  	    }
//# 
//# 	    kawtThread.processEvent
//#  		('k', top.focus,
//#  		 new KeyEvent (top,
//#  			       KeyEvent.KEY_PRESSED, 0, 0,
//#  			       keyCode, KeyEvent.CHAR_UNDEFINED));
//# 
//#  	}
//#  	else
//#  	    kawtThread.processEvent
//#  		('k', top.focus,
//#  		 new KeyEvent (top,
//#  			      KeyEvent.KEY_TYPED, 0, 0,
//#  			      KeyEvent.VK_UNDEFINED, (char) keyCode));
//# 
//# 	flushRepaint ();
//#     }
//#endif


//#ifdef kjava
    public void penDown (int x, int y) {
//#else
//#     public void pointerPressed (int x, int y) {
//#endif
	/*
 	Frame frame = getActiveFrame ();
 	if (frame == null) return;
	*/

 	while (true) {
 	    Window topWindow = getTopWindow ();
 	    Point p = topWindow.getLocationOnScreen ();
 
 	    mouseOwner = topWindow.findComponentAt (x - p.x, y - p.y);
 
 	    if (mouseOwner != null) {
 		p = mouseOwner.getLocationOnScreen ();
 
 		mouseOrgX = p.x;
 		mouseOrgY = p.y;
 
 		kawtThread.processEvent
 		    ('m', mouseOwner,
 		     new MouseEvent (mouseOwner,
 				     MouseEvent.MOUSE_PRESSED, 0, 0,
 				     x-mouseOrgX, y-mouseOrgY, 0, false));
 
 		break;
 	    }
 	    else if (topWindow.isMenu)
 		topWindow.setVisible (false);
 	    else break;
 	}

	flushRepaint ();
     }
 
//#ifdef kjava 
    public void penUp (int x, int y) {
//#else
//#     public void pointerReleased (int x, int y) {
//#endif 
 	if (mouseOwner == null) return;
 
 	x -= mouseOrgX;
 	y -= mouseOrgY;
 
 	kawtThread.processEvent
 	    ('m', mouseOwner,
 	     new MouseEvent (mouseOwner,
 			     MouseEvent.MOUSE_RELEASED, 0, 0, x, y,
 			     0, false));
 
 
 	kawtThread.processEvent
 	    ('m', mouseOwner,
 	     new MouseEvent (mouseOwner,
 			     MouseEvent.MOUSE_CLICKED, 0, 0, x, y,
 			     0, false));

	flushRepaint ();
   }

 
//#ifdef kjava 
     public void penMove (int x, int y) {
//#else
//# 	 public void pointerDragged (int x, int y) {
//#endif
 	if (mouseOwner != null)
 	    kawtThread.processEvent
 		('m', mouseOwner,
 		 new MouseEvent (null, MouseEvent.MOUSE_DRAGGED, 0, 0,
 				 x-mouseOrgX, y-mouseOrgY, 0, false));
	flushRepaint ();
     }


//#ifdef kjava
    /*public void beamReceive (byte[] data) {
      System.out.println ("Wrapper Received <" + data.length + "> bytes of data");
      System.out.println ("Wrapper Received <" + new String (data) + ">" );
      if (com.sun.cldc.io.j2me.obex.Protocol.protocol != null)
      try {
      com.sun.cldc.io.j2me.obex.Protocol.protocol.newDatagram (data, data.length, "0.0.0.0") ;
      com.sun.cldc.io.j2me.obex.Protocol.protocol.buffer = data;
      } catch (IOException e) {
      System.out.println (e);
      }
      com.sun.cldc.io.j2me.obex.Protocol.protocol.notify ();
      Frame frame = getActiveFrame ();
      ((ActionListener)frame).actionPerformed (new ActionEvent (data, 0, "beamReceive"));
      }*/
//#endif

 

//#ifdef midp
//# 
//#     public void commandAction (javax.microedition.lcdui.Command c,
//# 			       javax.microedition.lcdui.Displayable s) {
//# 
//# 	Window top = getTopWindow ();
//# 	if (top.isMenu) {
//# 	    do {
//# 		top.setVisible (false);
//# 		top = getTopWindow ();
//# 	    }
//# 	    while (top.isMenu);
//# 	}
//# 	else if (top instanceof Frame && ((Frame) top).menuBar != null)
//# 	    ((Frame) top).menuBar.show ();
//#     }
//# 
//# 
//#     /** public for kawt-internal purposes. Do not touch! */
//# 
//#     public void paint (javax.microedition.lcdui.Graphics g) {
//# 
//# 	g.drawImage (offScreen, 0, 0,
//# 		     javax.microedition.lcdui.Graphics.TOP
//# 		     | javax.microedition.lcdui.Graphics.LEFT);
//# 	Graphics.dirty = false;
//#     }
//#endif
}




