/*
 * Decompiled with CFR 0.152.
 */
package de.kawt;

import de.kawt.FileListActivationListener;
import de.kawt.shell.AbstractShell;
import de.kawt.shell.DefaultShell;
import java.awt.BorderLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

public class FileList
extends Panel
implements MouseListener,
ItemListener {
    boolean active;
    List list = new List();
    Label title = new Label();
    AbstractShell shell;
    FileListActivationListener activationListener;

    public FileList(FileListActivationListener activationListener) {
        super(new BorderLayout());
        this.add("North", this.title);
        this.add("Center", this.list);
        this.title.addMouseListener(this);
        this.list.addItemListener(this);
        this.activationListener = activationListener;
        this.setShell(new DefaultShell());
        this.active = true;
        this.setActive(false);
    }

    public void setShell(AbstractShell shell) {
        this.shell = shell;
        this.cd(shell.pwd());
    }

    public AbstractShell getShell() {
        return this.shell;
    }

    public String getSelectedFile() {
        return this.list.getSelectedItem();
    }

    public void cd(String path) {
        this.shell.cd(path);
        this.title.setText(this.shell.pwd());
        Vector l = this.shell.ls();
        this.list.removeAll();
        int i = 0;
        while (i < l.size()) {
            this.list.add(l.elementAt(i).toString());
            ++i;
        }
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.setActive(true);
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.setActive(true);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (active) {
            this.title.setBackground(SystemColor.activeCaption);
            this.title.setForeground(SystemColor.activeCaptionText);
            if (this.activationListener != null) {
                this.activationListener.fileListActivated(this);
            }
        } else {
            this.title.setBackground(SystemColor.inactiveCaption);
            this.title.setForeground(SystemColor.inactiveCaptionText);
            this.list.deselect(this.list.getSelectedIndex());
        }
    }
}

