/*
 * Decompiled with CFR 0.152.
 */
package de.kawt;

import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class OptionDialog
extends Dialog
implements ActionListener {
    public static final int CLOSED_OPTION = 0;
    public static final int OK_OPTION = 1;
    public static final int YES_OPTION = 2;
    public static final int NO_OPTION = 4;
    public static final int CANCEL_OPTION = 8;
    public static final int INPUT_OPTION = 16;
    TextField inputLine;
    Panel buttons = new Panel();
    int pressed;

    public OptionDialog(Component component, String message, String title, String deflt, int options) {
        super(OptionDialog.getFrame(component), title, true);
        this.add("North", new Label(message));
        if ((options & 0x10) != 0) {
            this.inputLine = new TextField(deflt);
            this.add("Center", this.inputLine);
        }
        this.addButton(options, 2, "yes");
        this.addButton(options, 4, "no");
        this.addButton(options, 1, "ok");
        this.addButton(options, 8, "cancel");
        this.add("South", this.buttons);
        this.pack();
        this.show();
    }

    public static Frame getFrame(Component component) {
        while (component.getParent() != null) {
            component = component.getParent();
        }
        Window win = (Window)component;
        while (win.getOwner() != null) {
            win = win.getOwner();
        }
        return (Frame)win;
    }

    void addButton(int options, int code, String label) {
        if ((options & code) != 0) {
            Button button = new Button(label);
            this.buttons.add(button);
            button.setActionCommand("" + code);
            button.addActionListener(this);
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.pressed = Integer.parseInt(e.getActionCommand());
        this.dispose();
    }

    public static int showConfirmDialog(Component component, String msg, String title) {
        return OptionDialog.showConfirmDialog(component, msg, title, 14);
    }

    public static int showConfirmDialog(Component component, String msg, String title, int type) {
        return new OptionDialog((Component)component, (String)msg, (String)title, null, (int)type).pressed;
    }

    public static String showInputDialog(Component component, String msg) {
        OptionDialog od = new OptionDialog(component, msg, "Input", "", 25);
        return od.pressed == 1 ? od.inputLine.getText() : null;
    }

    public static void showMessageDialog(Component component, String msg) {
        OptionDialog od = new OptionDialog(component, msg, "Message", "Message", 1);
    }
}

