/*
 * Decompiled with CFR 0.152.
 */
package de.kawt;

import de.kawt.TabbedPane;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;

class TabControl
extends Canvas
implements MouseListener {
    int sel;
    boolean mono = SystemColor.control.equals(Color.white);
    Vector titles = new Vector();
    TabbedPane tp;

    TabControl(TabbedPane _tp) {
        this.tp = _tp;
        this.setBackground(SystemColor.control);
        this.addMouseListener(this);
    }

    public void add(String title) {
        this.titles.addElement(title);
        if (this.sel < 0) {
            this.sel = 0;
        }
        this.repaint();
    }

    public void remove(int index) {
        this.titles.removeElementAt(index);
        if (this.sel >= index) {
            --this.sel;
        }
        this.repaint();
    }

    public Dimension getMinimumSize() {
        FontMetrics m = this.getFontMetrics(this.getFont());
        return new Dimension(160, m.getHeight() + (this.mono ? 5 : 8));
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public void drawTab(Graphics g, int x, int y, int w, int h, int dt, String text) {
        if (this.mono) {
            g.setColor(Color.black);
            g.drawLine(x, y + h - 1, x, y + 2);
            g.drawLine(x, y + 2, x + 2, y);
            g.drawLine(x + 2, y, x + w - 2, y);
            g.drawLine(x + w - 2, y, x + w, y + 2);
            g.drawLine(x + w, y + 2, x + w, y + h - 1);
            g.drawString(text, x + 5 + dt, y + h - 5);
        } else {
            g.setColor(Color.white);
            g.drawLine(x, y + h - 1, x, y + 2);
            g.drawLine(x + 1, y + h - 1, x + 1, y + 1);
            g.drawLine(x + 3, y, x + w - 3, y);
            g.drawLine(x + 2, y + 1, x + w - 2, y + 1);
            g.setColor(Color.black);
            g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
            g.setColor(Color.gray);
            g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 2);
            g.setColor(SystemColor.controlText);
            g.drawString(text, x + 5 + dt, y + h - 8);
        }
    }

    public void paint(Graphics g) {
        int overlap;
        int ofs;
        int selOfs = ofs = (overlap = this.mono ? 0 : 2);
        int selW = 0;
        FontMetrics metrics = g.getFontMetrics();
        int h = this.getSize().height;
        if (this.titles.size() > 0) {
            int i = 0;
            while (i < this.titles.size()) {
                String title = (String)this.titles.elementAt(i);
                int w = metrics.stringWidth(title) + 10;
                if (i == this.sel) {
                    selOfs = ofs;
                    selW = w;
                } else {
                    this.drawTab(g, ofs, 2, w, h, 0, title);
                }
                ofs += w;
                ++i;
            }
            this.drawTab(g, selOfs - overlap, 0, selW + overlap + overlap, h, overlap, (String)this.titles.elementAt(this.sel));
            if (!this.mono) {
                g.setColor(Color.white);
                g.drawLine(0, h - 2, selOfs - 1, h - 2);
                g.drawLine(selOfs + selW + 2, h - 2, this.getSize().width, h - 2);
            }
            g.drawLine(0, h - 1, selOfs - 1, h - 1);
            g.drawLine(selOfs + selW + 1, h - 1, this.getSize().width, h - 1);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent me) {
        int xofs = 0;
        int mx = me.getX();
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        int i = 0;
        while (i < this.titles.size()) {
            int nextOfs = xofs + 10 + fm.stringWidth((String)this.titles.elementAt(i));
            if (mx >= xofs && mx < nextOfs) {
                this.tp.setSelectedIndex(i);
                break;
            }
            xofs = nextOfs;
            ++i;
        }
    }
}

