/*
 * Decompiled with CFR 0.152.
 */
package de.kawt.shell;

import de.kawt.shell.AbstractShell;
import de.kawt.shell.FileInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Vector;

public class FtpShell
extends AbstractShell {
    Socket controlConnection;
    InputStream controlInputStream;
    OutputStream controlOutputStream;
    Socket dataConnection;
    InputStream dataInputStream;
    OutputStream dataOutputStream;
    String host;
    String user;
    String pass;
    String path = "/";
    Vector currentDir;

    String exec(String in) throws IOException {
        int i = 0;
        while (i < in.length()) {
            this.controlOutputStream.write((byte)in.charAt(i));
            ++i;
        }
        this.controlOutputStream.write(13);
        this.controlOutputStream.write(10);
        return this.readControlLine();
    }

    public boolean cd(String path) {
        try {
            this.exec("cwd " + path);
            this.currentDir = null;
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public Vector ls() {
        try {
            int i;
            Vector<FileInfo> currentDir = new Vector<FileInfo>();
            this.pasv(false);
            this.exec("list");
            StringBuffer s = new StringBuffer();
            boolean ignore = true;
            while ((i = this.dataInputStream.read()) != -1) {
                if (i == 13) {
                    if (ignore) {
                        ignore = false;
                    } else {
                        String line = s.toString();
                        int cut = line.lastIndexOf(32);
                        currentDir.addElement(new FileInfo(line.substring(cut + 1), line.charAt(0) == 'd' ? 1 : 0));
                    }
                    s = new StringBuffer();
                    continue;
                }
                if (i <= 31) continue;
                s.append((char)i);
            }
            this.closeStream();
            return currentDir;
        }
        catch (IOException e) {
            return null;
        }
    }

    public void closeStream() throws IOException {
        this.dataInputStream.close();
        this.dataOutputStream.close();
        this.dataConnection.close();
        this.readControlLine();
    }

    public void close() {
        try {
            this.controlInputStream.close();
            this.controlOutputStream.close();
            this.controlConnection.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void open(String host, String user, String pass) throws IOException {
        this.host = host;
        this.user = user;
        this.pass = pass;
        this.controlConnection = new Socket(host, 21);
        this.controlInputStream = this.controlConnection.getInputStream();
        this.controlOutputStream = this.controlConnection.getOutputStream();
        this.readControlLine();
        this.exec("user " + user);
        this.exec("pass " + pass);
    }

    void pasv(boolean binary) throws IOException {
        this.exec(binary ? "type i" : "type a");
        String passive = this.exec("pasv");
        passive = passive.substring(passive.indexOf(40, 0) + 1, passive.indexOf(41, 0));
        int len = passive.length();
        StringBuffer newPassive = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char ch = passive.charAt(i);
            if (ch == ',') {
                newPassive.append('.');
            } else {
                newPassive.append(ch);
            }
            ++i;
        }
        passive = newPassive.toString();
        int cut = passive.lastIndexOf(46);
        int port = Integer.parseInt(passive.substring(cut + 1));
        passive = passive.substring(0, cut);
        cut = passive.lastIndexOf(46);
        port += 256 * Integer.parseInt(passive.substring(cut + 1));
        passive = passive.substring(0, cut);
        this.dataConnection = new Socket(passive, port);
        this.dataInputStream = this.dataConnection.getInputStream();
        this.dataOutputStream = this.dataConnection.getOutputStream();
    }

    public String pwd() {
        return this.path;
    }

    public InputStream getInputStream(String name) throws IOException {
        this.pasv(true);
        String ret = this.exec("retr " + name);
        int i0 = ret.lastIndexOf(40);
        int i1 = ret.indexOf(32, i0);
        this.transferSize = Integer.parseInt(ret.substring(i0 + 1, i1));
        return this.dataInputStream;
    }

    public OutputStream getOutputStream(String name) throws IOException {
        this.pasv(true);
        String ret = this.exec("stor " + name);
        return this.dataOutputStream;
    }

    public void mkdir(String name) {
        try {
            this.exec("mkd " + name);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void rm(String name) {
        try {
            this.exec("dele " + name);
            this.exec("rmd " + name);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    String readControlLine() throws IOException {
        StringBuffer s;
        do {
            int i;
            s = new StringBuffer();
            while ((i = this.controlInputStream.read()) != -1 && i != 13) {
                if (i <= 31) continue;
                s.append((char)i);
            }
        } while (s.length() < 4 || s.charAt(3) == '-');
        return s.toString();
    }
}

