/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public class BorderLayout
implements LayoutManager {
    public static final String CENTER = "Center";
    public static final String SOUTH = "South";
    public static final String EAST = "East";
    public static final String NORTH = "North";
    public static final String WEST = "West";
    Component center;
    Component south;
    Component east;
    Component north;
    Component west;

    public void addLayoutComponent(String where, Component component) {
        if (where == null) {
            return;
        }
        if (where.equals(SOUTH)) {
            this.south = component;
        } else if (where.equals(EAST)) {
            this.east = component;
        } else if (where.equals(NORTH)) {
            this.north = component;
        } else if (where.equals(WEST)) {
            this.west = component;
        } else if (where.equals(CENTER)) {
            this.center = component;
        }
    }

    public void layoutContainer(Container parent) {
        int wWest = -1;
        int wEast = -1;
        int hNorth = -1;
        int hSouth = -1;
        int x0 = parent.insets.left;
        int y0 = parent.insets.top;
        int w0 = parent.w - parent.insets.left - parent.insets.right;
        int h0 = parent.h - parent.insets.top - parent.insets.bottom;
        if (this.north != null) {
            hNorth = this.north.getMinimumSize().height;
            this.north.w = w0;
            this.north.h = hNorth;
            this.north.x = x0;
            this.north.y = y0;
            this.north.valid = false;
        }
        if (this.south != null) {
            hSouth = this.south.getMinimumSize().height;
            this.south.w = w0;
            this.south.h = hSouth;
            this.south.x = x0;
            this.south.y = parent.h - hSouth - parent.insets.bottom;
            this.south.valid = false;
        }
        if (this.west != null) {
            wWest = this.west.getMinimumSize().width;
            this.west.h = h0 - hNorth - hSouth - 2;
            this.west.w = wWest;
            this.west.x = x0;
            this.west.y = y0 + hNorth + 1;
            this.west.valid = false;
        }
        if (this.east != null) {
            wEast = this.east.getMinimumSize().width;
            this.east.h = h0 - hNorth - hSouth - 2;
            this.east.w = wEast;
            this.east.x = w0 - wEast;
            this.east.y = y0 + hNorth + 1;
            this.east.valid = false;
        }
        if (this.center != null) {
            this.center.x = x0 + wWest + 1;
            this.center.y = y0 + hNorth + 1;
            this.center.w = w0 - wEast - wWest - 2;
            this.center.h = h0 - hNorth - hSouth - 2;
            this.center.valid = false;
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        Dimension d;
        int wMin = 0;
        int hMin = 0;
        if (this.west != null) {
            d = this.west.getMinimumSize();
            wMin += d.width + 1;
            hMin = d.height;
        }
        if (this.east != null) {
            d = this.east.getMinimumSize();
            wMin += d.width + 1;
            if (hMin < d.height) {
                hMin = d.height;
            }
        }
        if (this.center != null) {
            d = this.center.getMinimumSize();
            wMin += d.width;
            if (hMin < d.height) {
                hMin = d.height;
            }
        }
        if (this.north != null) {
            d = this.north.getMinimumSize();
            hMin += d.height + 1;
            if (wMin < d.width) {
                wMin = d.width;
            }
        }
        if (this.south != null) {
            d = this.south.getMinimumSize();
            hMin += d.height + 1;
            if (wMin < d.width) {
                wMin = d.width;
            }
        }
        return new Dimension(wMin + parent.insets.left + parent.insets.right, hMin + parent.insets.top + parent.insets.bottom);
    }

    public void removeLayoutComponent(Component component) {
    }
}

