/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.TooManyListenersException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

public class Button
extends Component {
    private ActionListener actionListener = null;
    String label;
    String command;
    boolean pressing = false;

    public Button() {
        this("");
    }

    public Button(String s) {
        this.setLabel(s);
        this.h = this.minH;
        this.w = this.minW;
    }

    public void addActionListener(ActionListener al) {
        if (this.actionListener != null) {
            throw new TooManyListenersException();
        }
        this.actionListener = al;
    }

    public void paint(Graphics g) {
        g.setColor(this.pressing ? SystemColor.activeCaption : this.background);
        g.fillRoundRect(1, 1, this.w - 2, this.h - 2, 2, 2);
        g.setColor(this.foreground);
        g.drawRoundRect(0, 0, this.w - 1, this.h - 1, 3, 3);
        g.setColor(this.pressing ? this.background : this.foreground);
        g.drawString(this.label, (this.w - this.minW) / 2 + 2, (this.h + this.minH) / 2 - 2);
    }

    public void processMouseEvent(MouseEvent me) {
        boolean isPressing;
        boolean inRange = me.getX() >= 0 && me.getX() <= this.w && me.getY() >= 0 && me.getY() <= this.h;
        boolean bl = isPressing = me.getID() == 501 || me.getID() == 506 && inRange;
        if (isPressing != this.pressing) {
            Graphics g = this.getGraphics();
            this.pressing = isPressing;
            if (g != null) {
                this.paint(g);
            }
        }
        if (inRange && me.getID() == 502 && this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, this.command != null ? this.command : this.label));
        }
    }

    public void removeActionListener(ActionListener al) {
        if (al == this.actionListener) {
            this.actionListener = null;
        }
    }

    public void setActionCommand(String s) {
        this.command = s;
    }

    public void setLabel(String s) {
        this.label = s;
        this.minW = this.fontMetrics.stringWidth(s) + 4;
        this.minH = this.fontMetrics.getHeight() + 2;
        if (this.minW > this.w) {
            this.invalidate();
        }
        this.repaint();
    }
}

