/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Vector;

public class CardLayout
implements LayoutManager {
    Vector cards = new Vector();
    Vector names = new Vector();
    int selected;

    public void addLayoutComponent(String name, Component card) {
        card.visible = this.cards.size() == this.selected;
        this.names.addElement(name);
        this.cards.addElement(card);
    }

    public void first(Container parent) {
        this.show(0);
    }

    public void last(Container parent) {
        this.show(this.cards.size() - 1);
    }

    public void layoutContainer(Container parent) {
        int i = 0;
        while (i < this.cards.size()) {
            Component c = (Component)this.cards.elementAt(i);
            c.x = parent.insets.left;
            c.y = parent.insets.top;
            c.w = parent.w - c.x - parent.insets.right;
            c.h = parent.h - c.y - parent.insets.bottom;
            c.valid = false;
            ++i;
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        int w = 0;
        int h = 0;
        int i = 0;
        while (i < this.cards.size()) {
            Component c = (Component)this.cards.elementAt(i);
            Dimension d = c.getMinimumSize();
            if (w < d.width) {
                w = d.width;
            }
            if (h < d.height) {
                h = d.height;
            }
            ++i;
        }
        return new Dimension(w, h);
    }

    public void next(Container parent) {
        if (this.selected < this.cards.size() - 1) {
            this.show(this.selected + 1);
        } else {
            this.show(0);
        }
    }

    public void previous(Container parent) {
        if (this.selected > 0) {
            this.show(this.selected - 1);
        } else {
            this.last(parent);
        }
    }

    public void show(Container parent, String name) {
        this.show(this.names.indexOf(name, 0));
    }

    void show(int i) {
        if (i == -1 || i == this.selected || i >= this.cards.size()) {
            return;
        }
        ((Component)this.cards.elementAt((int)this.selected)).visible = false;
        this.selected = i;
        ((Component)this.cards.elementAt(this.selected)).setVisible(true);
    }

    public void removeLayoutComponent(Component card) {
        int i = this.cards.indexOf(card, 0);
        if (i == this.selected) {
            this.show(i > 0 ? i : 0);
        }
        this.cards.removeElementAt(i);
        this.names.removeElementAt(i);
        if (this.selected > i) {
            --this.selected;
        }
    }
}

