/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.TooManyListenersException;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;

public class Checkbox
extends Component
implements ItemSelectable {
    private ActionListener actionListener = null;
    String label;
    boolean state = false;
    CheckboxGroup group;
    ItemListener itemListener;

    public Checkbox() {
        this("", null, false);
    }

    public Checkbox(String s) {
        this(s, null, false);
    }

    public Checkbox(String s, boolean checked) {
        this(s, null, checked);
    }

    public Checkbox(String s, boolean state, CheckboxGroup group) {
        this(s, group, state);
    }

    public Checkbox(String s, CheckboxGroup group, boolean state) {
        this.setLabel(s);
        this.setCheckboxGroup(group);
        this.setState(state);
    }

    public void addItemListener(ItemListener il) {
        if (this.itemListener != null) {
            throw new TooManyListenersException();
        }
        this.itemListener = il;
    }

    public Object[] getSelectedObjects() {
        if (this.state) {
            Object[] ret = new Object[]{this};
            return ret;
        }
        Object[] ret = new Object[]{};
        return ret;
    }

    public boolean getState() {
        return this.state;
    }

    public void paint(Graphics g) {
        int middle = this.h / 2;
        if (this.group == null) {
            g.drawRect(0, middle - 2, 7, 7);
            g.drawString(this.label, 12, middle + 6);
        } else {
            g.drawRoundRect(0, middle - 4, 9, 9, 4, 4);
            g.drawString(this.label, 12, middle + 6);
        }
        if (this.state && this.group != null) {
            g.fillRect(3, middle - 1, 4, 4);
        } else if (this.state && this.group == null) {
            g.setColor(Color.white);
            g.drawLine(7, middle - 2, 6, middle - 2);
            g.drawLine(7, middle - 2, 7, middle + 1);
            g.setColor(Color.black);
            g.drawLine(4, middle + 3, 9, middle - 2);
            g.drawLine(4, middle + 2, 9, middle - 3);
            g.drawLine(3, middle + 2, 8, middle - 3);
            g.fillRect(2, middle, 2, 2);
        }
    }

    public void processItemEvent(ItemEvent e) {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(e);
        }
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getID() != 501) {
            return;
        }
        Graphics g = this.getGraphics();
        if (this.group == null) {
            this.setState(!this.state);
        } else {
            this.setState(true);
        }
    }

    public void removeItemListener(ItemListener l) {
        if (this.itemListener == l) {
            this.itemListener = null;
        }
    }

    public void setCheckboxGroup(CheckboxGroup newGroup) {
        if (this.group != null) {
            this.group.checkboxes.removeElement(this);
        }
        this.group = newGroup;
        if (this.group != null) {
            this.group.checkboxes.addElement(this);
        }
    }

    public void setState(boolean sel) {
        if (sel != this.state) {
            if (this.group == null) {
                this.state = !this.state;
                this.repaint();
                this.processItemEvent(new ItemEvent(this, 1793, this, sel ? 1 : 2));
            } else {
                this.group.setSelectedCheckbox(this);
            }
        }
    }

    public void setLabel(String s) {
        this.label = s;
        FontMetrics fm = new FontMetrics(this.getFont());
        this.minW = fm.stringWidth(s) + 12;
        this.minH = fm.getHeight();
    }

    public String toString() {
        return this.label;
    }
}

