/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.TooManyListenersException;
import java.awt.Window;
import java.awt.Wrapper;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.ImageObserver;

public abstract class Component
implements ImageObserver {
    int x;
    int y;
    int w;
    int h;
    int minW = -1;
    int minH = -1;
    boolean enabled = true;
    boolean visible = true;
    boolean hasFocus = false;
    boolean valid = false;
    Component parent;
    MouseListener mouseListener;
    MouseMotionListener mml;
    KeyListener keyListener;
    Dimension minimumSize;
    FontMetrics fontMetrics = FontMetrics.defaultFontMetrics;
    Color background = Color.white;
    Color foreground = Color.black;

    public void addMouseListener(MouseListener l) {
        if (this.mouseListener != null) {
            throw new TooManyListenersException();
        }
        this.mouseListener = l;
    }

    public void addMouseMotionListener(MouseMotionListener l) {
        if (this.mml != null) {
            throw new TooManyListenersException();
        }
        this.mml = l;
    }

    public void addKeyListener(KeyListener l) {
        if (this.keyListener != null) {
            throw new TooManyListenersException();
        }
        this.keyListener = l;
    }

    public Component findComponentAt(int px, int py) {
        return this.visible && this.contains(px, py) ? this : null;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.w, this.h);
    }

    public Point getLocationOnScreen() {
        int sx = this.x;
        int sy = this.y;
        Component current = this;
        while (current.parent != null) {
            current = current.parent;
            if (!current.visible) {
                return null;
            }
            sx += current.x;
            sy += current.y;
        }
        if (!(current instanceof Window)) {
            return null;
        }
        return new Point(sx, sy);
    }

    public Font getFont() {
        return this.fontMetrics.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return new FontMetrics(font);
    }

    public Graphics getGraphics() {
        if (!this.visible) {
            return null;
        }
        int sx = this.x;
        int sy = this.y;
        Component current = this;
        Graphics g = new Graphics();
        while (current.parent != null) {
            current = current.parent;
            if (!current.visible) {
                return null;
            }
            if (current instanceof ScrollPane) {
                ScrollPane sp = (ScrollPane)current;
                Point p = sp.getLocationOnScreen();
                if (p == null) {
                    return null;
                }
                g.clipRect(p.x, p.y, sp.scrollManager.viewPortW, sp.scrollManager.viewPortH);
            }
            sx += current.x;
            sy += current.y;
        }
        if (!(current instanceof Window)) {
            return null;
        }
        g.translate(sx, sy);
        g.clipRect(0, 0, this.w, this.h);
        Window window = (Window)current;
        Frame frame = window.owner;
        int i0 = 0;
        if (frame != window && (i0 = frame.windows.indexOf(window, 0) + 1) == 0) {
            return null;
        }
        int i = i0;
        while (i < frame.windows.size()) {
            g._sub((Window)frame.windows.elementAt(i));
            ++i;
        }
        return g;
    }

    public Dimension getMaximumSize() {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public Dimension getSize() {
        return new Dimension(this.w, this.h);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.minW == -1 ? this.w : this.minW, this.minH == -1 ? this.h : this.minH);
    }

    public boolean contains(int x, int y) {
        return x >= 0 && x <= this.w && y >= 0 && y <= this.h;
    }

    void doLayout() {
        this.valid = true;
    }

    public Container getParent() {
        return this.parent instanceof Container ? (Container)this.parent : null;
    }

    public void invalidate() {
        this.valid = false;
        if (this.parent != null) {
            this.parent.invalidate();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setBackground(Color c) {
        if (!this.background.equals(c)) {
            this.background = c;
            this.repaint();
        }
    }

    public void setBounds(int x, int y, int w, int h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public void setEnabled(boolean b) {
        if (this.enabled != b) {
            this.enabled = b;
            this.repaint();
        }
    }

    public void setForeground(Color c) {
        if (!this.foreground.equals(c)) {
            this.foreground = c;
            this.repaint();
        }
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setSize(int w, int h) {
    }

    public void setSize(Dimension d) {
        this.w = d.width;
        this.h = d.height;
    }

    public void paint(Graphics g) {
    }

    public void paintAll(Graphics g) {
        if (this.visible && g != null) {
            this.paint(g);
        }
    }

    public void proxyRequestFocus(Component c) {
        if (this.parent != null) {
            this.parent.proxyRequestFocus(c);
        }
    }

    public void requestFocus() {
        if (this.parent != null) {
            this.parent.proxyRequestFocus(this);
        }
    }

    public void update(Graphics g) {
        g.setColor(this.background);
        g.fillRect(0, 0, this.w, this.h);
        g.setColor(this.foreground);
        this.paintAll(g);
    }

    public void repaint(int x, int y, int w, int h) {
        Wrapper.wrapper.addRepaint(this, new Rectangle(x, y, w, h));
    }

    public void repaint() {
        Wrapper.wrapper.addRepaint(this, new Rectangle(0, 0, this.w, this.h));
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.getID() == 506) {
            if (this.mml != null) {
                this.mml.mouseDragged(e);
            }
            return;
        }
        if (this.mouseListener == null) {
            return;
        }
        switch (e.getID()) {
            case 501: {
                this.mouseListener.mousePressed(e);
                break;
            }
            case 502: {
                this.mouseListener.mouseReleased(e);
                break;
            }
            case 500: {
                this.mouseListener.mouseClicked(e);
            }
        }
    }

    public void processKeyEvent(KeyEvent e) {
        if (this.keyListener == null) {
            return;
        }
        switch (e.getID()) {
            case 257: {
                this.keyListener.keyPressed(e);
                break;
            }
            case 258: {
                this.keyListener.keyReleased(e);
                break;
            }
            case 256: {
                this.keyListener.keyTyped(e);
            }
        }
    }

    public void setVisible(boolean v) {
        if (v != this.visible) {
            this.visible = v;
            this.invalidate();
            this.repaint();
        }
    }

    public void validate() {
        this.valid = true;
    }

    Window _getWindow() {
        Component w = this;
        while (w.parent != null) {
            w = w.parent;
        }
        return (Window)w;
    }
}

