/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Vector;

public class Container
extends Component {
    static Insets nullInsets = new Insets(0, 0, 0, 0);
    Vector children = new Vector();
    LayoutManager layoutManager = FlowLayout.defaultLayout;
    protected Insets insets = nullInsets;

    public Container() {
    }

    public Container(LayoutManager layoutManager) {
        this();
        this.layoutManager = layoutManager;
    }

    public Component add(Component component) {
        this.add(null, component);
        return component;
    }

    public Component add(String where, Component c) {
        this.children.addElement(c);
        c.parent = this;
        if (this.layoutManager != null) {
            this.layoutManager.addLayoutComponent(where, c);
        }
        this.invalidate();
        return c;
    }

    public void add(Component c, Object where) {
        this.add((String)where, c);
    }

    public Component findComponentAt(int px, int py) {
        if (!this.visible || !this.contains(px, py)) {
            return null;
        }
        int i = 0;
        while (i < this.children.size()) {
            Component c = (Component)this.children.elementAt(i);
            if ((c = c.findComponentAt(px - c.x, py - c.y)) != null) {
                return c;
            }
            ++i;
        }
        return this;
    }

    public Component getComponent(int i) {
        return (Component)this.children.elementAt(i);
    }

    public int getComponentCount() {
        return this.children.size();
    }

    public Component[] getComponents() {
        Component[] result = new Component[this.children.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getComponent(i);
            ++i;
        }
        return result;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public Dimension getMinimumSize() {
        return this.layoutManager != null ? this.layoutManager.minimumLayoutSize(this) : this.getSize();
    }

    public boolean isAncestorOf(Component c) {
        do {
            if (c.parent != this) continue;
            return true;
        } while ((c = c.parent) != null);
        return false;
    }

    public LayoutManager getLayout() {
        return this.layoutManager;
    }

    public void paintAll(Graphics g) {
        if (this.visible && g != null) {
            if (!this.valid) {
                this.doLayout();
            }
            this.paint(g.create());
            int i = 0;
            while (i < this.children.size()) {
                Component child = (Component)this.children.elementAt(i);
                if (child.visible && g.hitClip(child.x, child.y, child.w, child.h)) {
                    Graphics g2 = g.create(child.x, child.y, child.w, child.h);
                    if (!child.background.equals(this.background)) {
                        child.update(g2);
                    } else {
                        child.paintAll(g2);
                    }
                }
                ++i;
            }
        }
    }

    public void paintComponents(Graphics g) {
        int i = 0;
        while (i < this.children.size()) {
            Component child = (Component)this.children.elementAt(i);
            child.paintAll(g.create(child.x, child.y, child.w, child.h));
            ++i;
        }
    }

    public void removeAll() {
        int i = this.children.size() - 1;
        while (i >= 0) {
            this.remove((Component)this.children.elementAt(i));
            --i;
        }
    }

    public void remove(Component c) {
        this.children.removeElement(c);
        if (this.layoutManager != null) {
            this.layoutManager.removeLayoutComponent(c);
        }
        this.invalidate();
    }

    public void setLayout(LayoutManager mgr) {
        this.layoutManager = mgr;
        this.invalidate();
    }

    public void doLayout() {
        if (this.layoutManager != null) {
            this.layoutManager.layoutContainer(this);
        }
        int i = 0;
        while (i < this.children.size()) {
            ((Component)this.children.elementAt(i)).doLayout();
            ++i;
        }
        this.valid = true;
    }

    public void validate() {
        if (!this.valid) {
            this.doLayout();
            this.repaint();
        }
    }

    public void update(Graphics g) {
        if (g == null) {
            return;
        }
        g.setColor(this.background);
        g.fillRect(0, 0, this.w, this.h);
        g.setColor(this.foreground);
        this.paintAll(g);
    }
}

