/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KawtThread;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.Wrapper;

public class Dialog
extends Window {
    String title;
    boolean modal;

    public Dialog(Frame w) {
        this(w, "", false);
        this.insets = new Insets(16, 0, 0, 0);
    }

    public Dialog(Frame w, String t) {
        this(w, t, false);
    }

    public Dialog(Frame w, String t, boolean modal) {
        super(w);
        this.modal = modal;
        this.insets = new Insets(16, 4, 4, 4);
        this.setTitle(t);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.owner.w, super.getMinimumSize().height);
    }

    public void paint(Graphics g) {
        String s = this.title;
        if (s == null) {
            s = "No Title";
        }
        g.setFont(g.getFont().deriveFont(1));
        g.setColor(SystemColor.activeCaption);
        g.drawRoundRect(0, 0, this.w - 1, this.h - 1, 3, 3);
        g.drawRoundRect(1, 1, this.w - 3, this.h - 3, 2, 2);
        g.fillRect(2, 2, this.w - 4, 12);
        g.setColor(Color.white);
        g.drawString(s, (this.w - g.getFontMetrics().stringWidth(s)) / 2, 12);
    }

    public void setVisible(boolean vis) {
        if (vis == this.visible) {
            return;
        }
        super.setVisible(vis);
        if (this.modal) {
            if (vis) {
                KawtThread current = (KawtThread)Thread.currentThread();
                KawtThread kawtThread = Wrapper.kawtThread;
                KawtThread kawtThread2 = current;
                synchronized (kawtThread2) {
                    if (kawtThread == current) {
                        Wrapper.kawtThread = new KawtThread();
                        Wrapper.kawtThread.start();
                        Wrapper.kawtThread.save = current;
                        current.type = 0;
                    } else {
                        current.type = 121;
                    }
                    current.notify();
                    while (current.type != 120) {
                        try {
                            current.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            KawtThread thread = Wrapper.kawtThread;
            KawtThread kawtThread = thread.save;
            synchronized (kawtThread) {
                thread.save.type = 120;
                thread.save.notify();
                while (thread.save.type != 121) {
                    try {
                        thread.save.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void setTitle(String t) {
        this.title = t;
        this.repaint();
    }
}

