/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import de.kawt.FileList;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class FileDialog
extends Dialog
implements ActionListener {
    public static final int LOAD = 0;
    public static final int SAVE = 1;
    int mode;
    FileList fileList;
    TextField textField = new TextField();
    String directory;
    String file;

    public FileDialog(Frame frame) {
        this(frame, null, 0);
    }

    public FileDialog(Frame frame, String title) {
        this(frame, title, 0);
    }

    public FileDialog(Frame frame, String title, int mode) {
        super(frame, title == null ? "Select File" : title, true);
        this.mode = mode;
        this.fileList = new FileList(null);
        this.fileList.setActive(true);
        this.add("Center", this.fileList);
        Panel south = new Panel(new BorderLayout());
        south.add("West", new Label("File:"));
        south.add("Center", this.textField);
        Panel buttons = new Panel();
        Button open = new Button(mode == 0 ? "Open" : "Save");
        open.addActionListener(this);
        buttons.add(open);
        Button cancel = new Button("Cancel");
        cancel.addActionListener(this);
        buttons.add(cancel);
        south.add("East", buttons);
        this.add("South", south);
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        if (!e.getActionCommand().equals("Cancel")) {
            this.file = this.textField.getText();
            if (this.file == null || this.file.equals("")) {
                this.file = this.fileList.getSelectedFile();
                int len = this.file.length();
                if (len > 0 && this.file.charAt(len - 1) == '/') {
                    this.fileList.cd(this.file);
                    this.file = null;
                    return;
                }
            }
            this.directory = this.fileList.getShell().pwd();
        }
        this.setVisible(false);
    }

    public String getFile() {
        return this.file;
    }

    public String getDirectory() {
        return this.directory;
    }
}

