/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;

public class GifLoader {
    int globalWidth;
    int globalHeight;
    int colorResolution;
    int globalPixelBits;
    int background;
    byte[] globalColorMap;
    InputStream is;
    static final int[] interlaceMap;
    int top;
    int left;
    int width;
    int height;
    int bufPos;
    int resetCode;
    int eofCode;
    int pixelBits;
    int colors;
    byte[] colorMap;
    byte[] buf;
    byte[] writeBuf;
    int writePos;
    int blockSize;
    int row;
    short[] prefix;
    byte[] suffix;
    byte[] stack;
    int screenBits = Toolkit.getDefaultToolkit().getColorModel().getPixelSize();
    int codeSize;
    int clearCode;
    int firstFree;
    int freeCode;
    int maxCode;
    int minCodeSize;
    int tableSize;
    int tableLimit;
    int x;
    int y;
    boolean interlaced;
    Image image;
    int current;
    int filled;
    int mask;

    static {
        int[] nArray = new int[13];
        nArray[1] = 8;
        nArray[2] = 4;
        nArray[3] = 12;
        nArray[4] = 2;
        nArray[5] = 6;
        nArray[6] = 10;
        nArray[7] = 1;
        nArray[8] = 3;
        nArray[9] = 5;
        nArray[10] = 7;
        nArray[11] = 9;
        nArray[12] = 11;
        interlaceMap = nArray;
    }

    public GifLoader(InputStream is) {
        this.is = is;
    }

    public Image load() throws IOException {
        int st;
        this.buf = new byte[256];
        this.readBytes(this.buf, 6);
        this.globalWidth = this.readWord();
        this.globalHeight = this.readWord();
        int misc = this.is.read();
        this.colorResolution = (misc >> 4 & 7) + 1;
        this.globalPixelBits = (misc & 7) + 1;
        this.background = this.is.read();
        this.is.read();
        if ((misc & 0x80) != 0) {
            this.globalColorMap = new byte[1 << this.globalPixelBits];
            this.readColorMap(this.globalColorMap, this.globalColorMap.length);
        }
        this.image = new Image(this.globalWidth, this.globalHeight, this.screenBits);
        this.writeBuf = new byte[this.globalWidth + 16];
        block5: while (true) {
            st = this.is.read();
            switch (st) {
                case 44: {
                    this.readImage();
                    continue block5;
                }
                case 33: {
                    this.readExtension();
                    continue block5;
                }
                case -1: 
                case 0: 
                case 59: {
                    return this.image;
                }
            }
            break;
        }
        throw new RuntimeException("bst#" + st);
    }

    void readExtension() throws IOException {
        int cnt;
        this.is.read();
        while ((cnt = this.is.read()) > 0) {
            this.readBytes(this.buf, cnt);
        }
    }

    void readBytes(byte[] buf, int count) throws IOException {
        int ok;
        int pos = 0;
        while ((ok = this.is.read(buf, pos, count - pos)) != -1 && ok != 0 && (pos += ok) < count) {
        }
        if (count != pos) {
            throw new RuntimeException("Read past eof!");
        }
    }

    int readWord() throws IOException {
        int b = this.is.read();
        return b | this.is.read() << 8;
    }

    void initTable() {
        this.codeSize = this.minCodeSize + 1;
        this.clearCode = 1 << this.minCodeSize;
        this.eofCode = this.clearCode + 1;
        this.freeCode = this.firstFree = this.clearCode + 2;
        this.maxCode = 1 << this.codeSize;
        this.mask = (1 << this.codeSize) - 1;
    }

    void expandData() throws IOException {
        int code;
        this.minCodeSize = this.is.read();
        this.initTable();
        this.prefix = new short[this.maxCode - this.firstFree];
        this.suffix = new byte[this.maxCode - this.firstFree];
        this.stack = new byte[this.maxCode - this.firstFree + 1];
        int oldCode = 0;
        int finalChar = 0;
        int sp = 0;
        while ((code = this.readCode()) != this.eofCode) {
            int suffixChar;
            if (code == this.clearCode) {
                this.initTable();
                oldCode = code = this.readCode();
                suffixChar = code;
                finalChar = code;
                this.putByte(suffixChar);
                continue;
            }
            int inputCode = code;
            if (code >= this.freeCode) {
                code = oldCode;
                this.stack[sp++] = (byte)finalChar;
            }
            while (code >= this.firstFree) {
                this.stack[sp++] = this.suffix[code - this.firstFree];
                code = this.prefix[code - this.firstFree];
            }
            finalChar = code;
            suffixChar = code;
            this.stack[sp++] = (byte)finalChar;
            while (sp > 0) {
                this.putByte(this.stack[--sp]);
            }
            this.suffix[this.freeCode - this.firstFree] = (byte)suffixChar;
            this.prefix[this.freeCode - this.firstFree] = (short)oldCode;
            ++this.freeCode;
            oldCode = inputCode;
            if (this.freeCode < this.maxCode || this.codeSize >= 12) continue;
            ++this.codeSize;
            this.mask = (1 << this.codeSize) - 1;
            this.maxCode <<= 1;
            if (this.prefix.length >= this.maxCode) continue;
            short[] tmps = this.prefix;
            this.prefix = new short[this.maxCode - this.firstFree];
            System.arraycopy(tmps, 0, this.prefix, 0, tmps.length);
            byte[] tmp = this.suffix;
            this.suffix = new byte[this.maxCode - this.firstFree];
            System.arraycopy(tmp, 0, this.suffix, 0, tmp.length);
            tmp = this.stack;
            this.stack = new byte[this.maxCode - this.firstFree + 1];
            System.arraycopy(tmp, 0, this.stack, 0, tmp.length);
        }
    }

    void readImage() throws IOException {
        this.left = this.readWord();
        this.top = this.readWord();
        this.width = this.readWord();
        this.height = this.readWord();
        this.row = 0;
        int misc = this.is.read();
        this.interlaced = (misc & 0x40) != 0;
        this.pixelBits = this.globalPixelBits;
        if ((misc & 0x80) != 0) {
            this.pixelBits = (misc & 7) + 1;
            this.colorMap = new byte[1 << this.pixelBits];
            this.readColorMap(this.colorMap, this.colorMap.length);
        } else {
            this.colorMap = this.globalColorMap;
        }
        this.writePos = 0;
        this.colors = 1 << this.pixelBits;
        this.blockSize = 0;
        this.bufPos = 0;
        this.expandData();
    }

    void readColorMap(byte[] map, int len) throws IOException {
        int i = 0;
        while (i < len) {
            int r = 255 - this.is.read();
            int g = 255 - this.is.read();
            int b = 255 - this.is.read();
            map[i] = this.screenBits < 8 ? (byte)((r + g + b) / 3 >> 8 - this.screenBits) : (byte)((g /= 43) + 6 * ((b /= 43) % 3) + (r /= 43) * 3 * 6 + b / 3 * 3 * 6 * 6);
            ++i;
        }
    }

    void putByte(int code) {
        this.writeBuf[this.writePos] = this.colorMap[code & 0xFF];
        if (++this.writePos >= this.width) {
            int dy = this.top + (this.interlaced && this.row + 13 <= this.height ? 13 * (this.row / 13) + interlaceMap[this.row % 13] : this.row);
            this.image.setPixels(this.left, dy, this.width, 1, null, this.writeBuf, 0, this.width);
            this.writePos = 0;
            ++this.row;
        }
    }

    int readCode() throws IOException {
        while (this.filled < this.codeSize) {
            if (this.bufPos >= this.blockSize) {
                this.blockSize = this.is.read();
                this.readBytes(this.buf, this.blockSize);
                this.bufPos = 0;
            }
            this.current |= (this.buf[this.bufPos++] & 0xFF) << this.filled;
            this.filled += 8;
        }
        int result = this.current & this.mask;
        this.filled -= this.codeSize;
        this.current >>= this.codeSize;
        return result;
    }
}

