/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import com.sun.kjava.Bitmap;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.ImageObserver;
import java.util.Vector;

public class Graphics {
    static Graphics current;
    static Object lock;
    static Rectangle screenRect;
    static boolean monochrome;
    int nativeDrawMode = 1;
    int originX;
    int originY;
    Color color = Color.black;
    boolean xorMode = false;
    Font font = Font.defaultFont;
    Rectangle[] clip;
    int clipCount;

    static {
        lock = new Object();
        screenRect = new Rectangle(0, 0, 160, 160);
        monochrome = Toolkit.pixelBits == 1;
    }

    Graphics() {
        this.originX = 0;
        this.originY = 0;
        this.clipCount = 1;
        this.clip = new Rectangle[1];
        this.clip[0] = screenRect;
    }

    Graphics(Graphics g) {
        this.originX = g.originX;
        this.originY = g.originY;
        this.xorMode = g.xorMode;
        this.color = g.color;
        this.nativeDrawMode = g.nativeDrawMode;
        this.clipCount = g.clipCount;
        this.clip = new Rectangle[this.clipCount];
        System.arraycopy(g.clip, 0, this.clip, 0, this.clipCount);
    }

    public Graphics create() {
        return new Graphics(this);
    }

    public Graphics create(int x, int y, int width, int height) {
        Graphics g = new Graphics(this);
        g.translate(x, y);
        g.clipRect(0, 0, width, height);
        return g;
    }

    public void checkContext(int i) {
        if (current != this || this.clipCount != 1) {
            current = this;
            Rectangle r = this.clip[i];
            com.sun.kjava.Graphics.setDrawRegion((int)r.x, (int)r.y, (int)r.width, (int)r.height);
        }
    }

    public void clipRect(int x, int y, int w, int h) {
        current = null;
        Rectangle r = new Rectangle(x + this.originX, y + this.originY, w, h);
        int dst = 0;
        int i = 0;
        while (i < this.clipCount) {
            Rectangle ir = this.clip[i].intersection(r);
            if (ir.width > 0 && ir.height > 0) {
                this.clip[dst++] = ir;
            }
            ++i;
        }
        this.clipCount = dst;
    }

    public void setClip(int x, int y, int w, int h) {
        current = null;
        this.clip[0] = new Rectangle(x + this.originX, y + this.originY, w, h);
        this.clipCount = 1;
    }

    public void clearRect(int x, int y, int w, int h) {
        Object object = lock;
        synchronized (object) {
            int i = 0;
            while (i < this.clipCount) {
                this.checkContext(i);
                com.sun.kjava.Graphics.drawRectangle((int)(this.originX + x), (int)(this.originY + y), (int)w, (int)h, (int)0, (int)0);
                ++i;
            }
        }
    }

    public boolean drawImage(Image image, int x, int y, ImageObserver observer) {
        Object object = lock;
        synchronized (object) {
            int i = 0;
            while (i < this.clipCount) {
                this.checkContext(i);
                com.sun.kjava.Graphics.drawBitmap((int)(x + this.originX), (int)(y + this.originY), (Bitmap)image.bitmap);
                ++i;
            }
        }
        return true;
    }

    public void dispose() {
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        Object object = lock;
        synchronized (object) {
            int i = 0;
            while (i < this.clipCount) {
                this.checkContext(i);
                com.sun.kjava.Graphics.drawLine((int)(x1 + this.originX), (int)(y1 + this.originY), (int)(x2 + this.originX), (int)(y2 + this.originY), (int)this.nativeDrawMode);
                ++i;
            }
        }
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        Object object = lock;
        synchronized (object) {
            int j = 0;
            while (j < this.clipCount) {
                this.checkContext(j);
                int i = 0;
                while (i < nPoints - 1) {
                    com.sun.kjava.Graphics.drawLine((int)(xPoints[i] + this.originX), (int)(yPoints[i] + this.originY), (int)(xPoints[i + 1] + this.originX), (int)(yPoints[i + 1] + this.originY), (int)this.nativeDrawMode);
                    ++i;
                }
                ++j;
            }
        }
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        int arc = (arcWidth + arcHeight) / 2;
        if (arc > 4095) {
            arc = 4095;
        }
        Object object = lock;
        synchronized (object) {
            int i = 0;
            while (i < this.clipCount) {
                this.checkContext(i);
                com.sun.kjava.Graphics.drawBorder((int)(this.originX + x + 1), (int)(this.originY + y + 1), (int)(width - 1), (int)(height - 1), (int)this.nativeDrawMode, (int)(arc << 8 | 1));
                ++i;
            }
        }
    }

    public void drawString(String text, int x, int y) {
        Object object = lock;
        synchronized (object) {
            int j = 0;
            while (j < this.clipCount) {
                this.checkContext(j);
                y += this.originY - 10;
                x += this.originX;
                if (!this.font.isBold() || !Toolkit.colorKvm && this.nativeDrawMode != 0) {
                    com.sun.kjava.Graphics.drawString((String)text, (int)x, (int)y, (int)this.nativeDrawMode);
                } else {
                    int i = 0;
                    while (i < text.length()) {
                        String cc = "" + text.charAt(i);
                        com.sun.kjava.Graphics.drawString((String)cc, (int)x++, (int)y, (int)this.nativeDrawMode);
                        com.sun.kjava.Graphics.drawString((String)cc, (int)x, (int)y, (int)this.nativeDrawMode);
                        x += com.sun.kjava.Graphics.getWidth((String)cc);
                        ++i;
                    }
                }
                ++j;
            }
        }
    }

    public void drawOval(int x, int y, int w, int h) {
        int d = (w < h ? w : h) / 2;
        this.drawRoundRect(x, y, w, h, d, d);
    }

    public void drawRect(int x, int y, int width, int height) {
        Object object = lock;
        synchronized (object) {
            int i = 0;
            while (i < this.clipCount) {
                this.checkContext(i);
                com.sun.kjava.Graphics.drawBorder((int)(this.originX + x + 1), (int)(this.originY + y + 1), (int)(width - 1), (int)(height - 1), (int)this.nativeDrawMode, (int)1);
                ++i;
            }
        }
    }

    public void fillRect(int x, int y, int width, int height) {
        Object object = lock;
        synchronized (object) {
            int i = 0;
            while (i < this.clipCount) {
                this.checkContext(i);
                com.sun.kjava.Graphics.drawRectangle((int)(this.originX + x), (int)(this.originY + y), (int)width, (int)height, (int)this.nativeDrawMode, (int)0);
                ++i;
            }
        }
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        Object object = lock;
        synchronized (object) {
            int i = 0;
            while (i < this.clipCount) {
                this.checkContext(i);
                com.sun.kjava.Graphics.drawRectangle((int)(this.originX + x), (int)(this.originY + y), (int)width, (int)height, (int)this.nativeDrawMode, (int)(arcWidth + arcHeight >> 1));
                ++i;
            }
        }
    }

    public Font getFont() {
        return this.font;
    }

    public synchronized boolean hitClip(int x, int y, int w, int h) {
        x += this.originX;
        y += this.originY;
        int i = 0;
        while (i < this.clipCount) {
            Rectangle r = this.clip[i];
            if (r.x <= x + w && r.x + r.width >= x && r.y <= y + h && r.y + r.height >= y) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public FontMetrics getFontMetrics() {
        return new FontMetrics(this.font);
    }

    public FontMetrics getFontMetrics(Font font) {
        return new FontMetrics(font);
    }

    public void setColor(Color c) {
        int sum;
        this.color = c;
        if (this.xorMode) {
            return;
        }
        this.nativeDrawMode = monochrome ? ((sum = ((c.rgb & 0xFF0000) >> 16) + ((c.rgb & 0xFF00) >> 8) + (c.rgb & 0xFF)) > 256 ? (sum > 512 ? 0 : 4) : 1) : (c.rgb << 8) + 5;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setPaintMode() {
        this.xorMode = false;
        this.setColor(this.color);
    }

    public void setXORMode(Color c2) {
        this.xorMode = true;
        this.nativeDrawMode = 5;
    }

    public void translate(int x, int y) {
        this.originX += x;
        this.originY += y;
    }

    void _sub(Window w) {
        Rectangle[] iw = new Rectangle[]{new Rectangle(0, 0, Graphics.screenRect.width, w.y), new Rectangle(0, w.y + w.h, Graphics.screenRect.width, Graphics.screenRect.height), new Rectangle(0, w.y, w.x, w.h), new Rectangle(w.x + w.w, w.y, Graphics.screenRect.width, w.h)};
        Vector<Rectangle> newClip = new Vector<Rectangle>();
        int i = 0;
        while (i < this.clipCount) {
            Rectangle r = this.clip[i];
            int j = 0;
            while (j < 4) {
                Rectangle ir = r.intersection(iw[j]);
                if (ir.width > 0 && ir.height > 0) {
                    newClip.addElement(ir);
                }
                ++j;
            }
            ++i;
        }
        this.clipCount = newClip.size();
        if (this.clipCount > this.clip.length) {
            this.clip = new Rectangle[newClip.size()];
        }
        i = 0;
        while (i < this.clipCount) {
            this.clip[i] = (Rectangle)newClip.elementAt(i);
            ++i;
        }
    }
}

