/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;

public class GridLayout
implements LayoutManager {
    int rows;
    int cols;
    int hGap;
    int vGap;

    public void addLayoutComponent(String where, Component component) {
    }

    public GridLayout(int rows, int cols) {
        this(rows, cols, 1, 1);
    }

    public GridLayout(int rows, int cols, int hGap, int vGap) {
        this.rows = rows;
        this.cols = cols;
        this.hGap = hGap;
        this.vGap = vGap;
        if (rows == 0 && cols == 0) {
            throw new RuntimeException("rows and cols must not both be 0");
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        int cw = 0;
        int ch = 0;
        int count = parent.children.size();
        int i = 0;
        while (i < count) {
            Component c = (Component)parent.children.elementAt(i);
            Dimension d = c.getMinimumSize();
            if (d.width > cw) {
                cw = d.width;
            }
            if (d.height > ch) {
                ch = d.height;
            }
            ++i;
        }
        int rowCount = this.rows == 0 ? (count + this.cols - 1) / this.cols : this.rows;
        int colCount = rowCount * this.cols < count ? (count + this.rows - 1) / this.rows : this.cols;
        return new Dimension(colCount * (cw + this.vGap) - this.vGap + parent.insets.left + parent.insets.right, rowCount * (ch + this.hGap) - this.hGap + parent.insets.top + parent.insets.bottom);
    }

    public void layoutContainer(Container parent) {
        int x0 = parent.insets.left;
        int y0 = parent.insets.top;
        int w0 = parent.w - x0 - parent.insets.right;
        int h0 = parent.h - y0 - parent.insets.bottom;
        int count = parent.children.size();
        int rowCount = this.rows == 0 ? (count + this.cols - 1) / this.cols : this.rows;
        int colCount = rowCount * this.cols < count ? (count + this.rows - 1) / this.rows : this.cols;
        int cellW = (w0 + this.hGap) / colCount;
        int cellH = (h0 + this.vGap) / rowCount;
        int idx = 0;
        int currY = y0;
        int idxY = 0;
        while (idxY < rowCount) {
            int currX = x0;
            int idxX = 0;
            while (idxX < colCount) {
                if (idx >= count) {
                    return;
                }
                Component c = (Component)parent.children.elementAt(idx++);
                c.x = currX;
                c.y = currY;
                c.w = cellW - this.hGap;
                c.h = cellH - this.vGap;
                c.valid = false;
                currX += cellW;
                ++idxX;
            }
            currY += cellH;
            ++idxY;
        }
    }

    public void removeLayoutComponent(Component component) {
    }
}

