/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import com.sun.kjava.Bitmap;
import java.awt.image.ColorModel;

public class Image {
    static final int WIDTH = 0;
    static final int HEIGHT = 1;
    Bitmap bitmap;
    short[] data;
    int lineLength;
    int depth;
    static final int HEADER_SIZE = 8;

    Image(int w, int h, int depth, byte[] data) {
        int byteW = (w + 7) / 8;
        if (byteW * h != data.length) {
            throw new RuntimeException("bw*h!=data.lengt");
        }
        this.bitmap = new Bitmap((short)byteW, data);
    }

    static byte hexToDec(char c) {
        return (byte)(c >= 'a' ? c - 97 : c - 48);
    }

    Image(int w, int h, int depth) {
        this.depth = depth;
        this.lineLength = (w * depth + 15) / 16;
        this.data = new short[8 + h * this.lineLength];
        this.data[0] = (short)w;
        this.data[1] = (short)h;
        this.data[2] = (short)(this.lineLength * 2);
        this.data[3] = 0;
        this.data[4] = (short)((depth << 8) + 1);
        this.data[5] = 0;
        this.data[6] = 0;
        this.data[7] = 0;
        this.bitmap = new Bitmap(this.data);
    }

    Image(int w, int h, int depth, String hexdata) {
        int byteW = (w + 7) / 8;
        byte[] data = new byte[hexdata.length() / 2];
        int cp = 0;
        int i = 0;
        while (cp < hexdata.length()) {
            data[i++] = (byte)(Image.hexToDec(hexdata.charAt(cp)) * 16 + Image.hexToDec(hexdata.charAt(cp + 1)));
            cp += 2;
        }
        this.bitmap = new Bitmap((short)byteW, data);
    }

    void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int dst = 8 + this.lineLength * y;
        int i = 0;
        if (this.depth == 1) {
            while (i < w) {
                int val = 0;
                int j = 15;
                while (j >= 0) {
                    val |= pixels[i++] << j;
                    --j;
                }
                this.data[dst++] = (short)val;
            }
        } else if (this.depth == 4) {
            while (i < w) {
                this.data[dst++] = (short)((pixels[i] << 12) + (pixels[i + 1] << 8) + (pixels[i + 2] << 4) + pixels[i + 3]);
                i += 4;
            }
        } else if (this.depth == 8) {
            while (i < w) {
                this.data[dst++] = (short)(((pixels[i] & 0xFF) << 8) + (pixels[i + 1] & 0xFF));
                i += 2;
            }
        } else {
            throw new RuntimeException("depth currently unsupported!");
        }
    }

    public int getWidth(Object observer) {
        return this.data[0];
    }

    public int getHeight(Object observer) {
        return this.data[1];
    }
}

