/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.ScrollManager;
import java.awt.SystemColor;
import java.awt.TooManyListenersException;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class List
extends Component
implements ItemSelectable {
    Vector elements = new Vector();
    int sel = -1;
    int newSel = -1;
    int lineH = 12;
    Choice choice;
    Menu menu;
    ScrollManager scrollManager;
    ItemListener il;

    public List() {
        this.scrollManager = new ScrollManager(this, 2);
    }

    List(Choice choice) {
        this.choice = choice;
        this.scrollManager = new ScrollManager(this, 5);
    }

    List(Menu menu) {
        this.menu = menu;
        this.scrollManager = new ScrollManager(this, 5);
    }

    void addObject(Object item, int index) {
        FontMetrics fm = new FontMetrics(this.getFont());
        int iw = fm.stringWidth("" + item) + 7;
        if (iw > this.minW) {
            this.minW = iw;
        }
        if (index <= -1) {
            this.elements.addElement(item);
        } else if (index >= this.elements.size()) {
            this.elements.addElement(item);
        } else {
            this.elements.insertElementAt(item, index);
        }
        this.doLayout();
        this.repaint();
    }

    public void add(String item) {
        this.addObject(item, -1);
    }

    public void add(String item, int index) {
        this.addObject(item, index);
    }

    public void addItemListener(ItemListener l) {
        if (this.il != null) {
            throw new TooManyListenersException();
        }
        this.il = l;
    }

    public Dimension getMinimumSize() {
        int mh = this.elements.size() * this.lineH + this.scrollManager.border;
        if (mh > 100) {
            mh = 100;
        }
        return new Dimension(this.minW + this.scrollManager.border, mh);
    }

    public int getSelectedIndex() {
        return this.sel;
    }

    public String getSelectedItem() {
        if (this.sel < 0 || this.sel >= this.elements.size()) {
            return null;
        }
        return (String)this.elements.elementAt(this.sel);
    }

    public Object[] getSelectedObjects() {
        return new Object[]{this.elements.elementAt(this.sel)};
    }

    public Component findComponentAt(int px, int py) {
        return this.scrollManager.findComponentAt(px, py);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.scrollManager.paint(g);
        int i = this.scrollManager.yOffset / this.lineH;
        int ty = -(this.scrollManager.yOffset % this.lineH);
        int tx = 1 - this.scrollManager.xOffset;
        while (ty < this.h) {
            g.setColor(i == this.newSel ? SystemColor.activeCaption : Color.white);
            g.fillRect(0, ty, this.scrollManager.viewPortW, this.lineH);
            if (i < this.elements.size()) {
                g.setColor(i == this.newSel ? Color.white : Color.black);
                g.drawString(this.elements.elementAt(i).toString(), tx, ty + 10);
            }
            ++i;
            ty += this.lineH;
        }
    }

    public void processMouseEvent(MouseEvent me) {
        if (me.getID() == 502) {
            this.select(this.newSel);
        }
        if (me.getID() != 506 && me.getID() != 501) {
            return;
        }
        int newNewSel = (this.scrollManager.yOffset + me.getY()) / this.lineH;
        if (newNewSel < 0) {
            newNewSel = 0;
        }
        if (newNewSel >= this.elements.size()) {
            newNewSel = this.elements.size() - 1;
        } else if (newNewSel != this.newSel) {
            this.newSel = newNewSel;
            if (this.scrollManager.vBar != null) {
                int sv = this.newSel * this.lineH;
                if (sv < this.scrollManager.vBar.currValue) {
                    this.scrollManager.vBar.currValue = sv;
                } else if (sv > this.scrollManager.vBar.currValue + this.scrollManager.vBar.currVisible) {
                    this.scrollManager.vBar.currValue = sv - this.scrollManager.vBar.currVisible;
                }
            }
            this.repaint();
        }
    }

    public void removeAll() {
        this.elements.removeAllElements();
        this.deselect(this.sel);
        this.minW = 20;
        this.doLayout();
        this.repaint();
    }

    public synchronized void doLayout() {
        this.scrollManager.doLayout(this.minW, this.elements.size() * this.lineH);
    }

    public int getItemCount() {
        return this.elements.size();
    }

    public void remove(int position) {
        if (this.sel == position) {
            this.deselect(this.sel);
        }
        this.elements.removeElementAt(position);
        this.doLayout();
        this.repaint();
    }

    public void remove(String item) {
        this.remove(this.elements.indexOf(item, 0));
    }

    public void removeItemListener(ItemListener l) {
        if (l == this.il) {
            this.il = null;
        }
    }

    public void deselect(int old) {
        if (old != this.sel || old == -1 || old >= this.elements.size()) {
            return;
        }
        this.newSel = -1;
        this.sel = -1;
        if (this.il != null) {
            this.il.itemStateChanged(new ItemEvent(this, 1793, this.elements.elementAt(old), 2));
        }
        this.repaint();
    }

    public void select(int index) {
        if (this.menu != null) {
            if (this.menu.win != null) {
                this.menu.win.setVisible(false);
                this.menu.win.owner.menuBar.win.setVisible(false);
            }
            if (index != -1) {
                MenuItem item = (MenuItem)this.elements.elementAt(index);
                if (item.al != null) {
                    item.al.actionPerformed(new ActionEvent(item, 1001, item.command == null ? item.label : item.command));
                }
            }
            return;
        }
        Component source = this;
        if (this.choice != null) {
            if (this.choice.win != null) {
                this.choice.win.setVisible(false);
            }
            source = this.choice;
        }
        if (index != this.sel) {
            if (this.choice != null) {
                this.choice.repaint();
            } else if (this.newSel == this.sel) {
                this.repaint();
            }
            this.newSel = this.sel = index;
        }
        if (this.il != null && index != -1) {
            this.il.itemStateChanged(new ItemEvent((ItemSelectable)((Object)source), 1793, this.elements.elementAt(index), 1));
        }
    }
}

