/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;

class MenuBarComponent
extends Component {
    MenuBar bar;
    Menu open;
    int selected = -1;

    MenuBarComponent(MenuBar bar) {
        this.bar = bar;
    }

    public Dimension getMinimumSize() {
        return new Dimension(Graphics.screenRect.width, 15);
    }

    public void paint(Graphics g) {
        g.setColor(Color.black);
        g.drawLine(1, 0, this.w - 3, 0);
        g.drawLine(1, this.h - 2, this.w - 2, this.h - 2);
        g.drawLine(2, this.h - 1, this.w - 3, this.h - 1);
        g.drawLine(0, 1, 0, this.h - 3);
        g.drawLine(this.w - 2, 1, this.w - 2, this.h - 2);
        g.drawLine(this.w - 1, 2, this.w - 1, this.h - 3);
        g.setFont(g.getFont().deriveFont(1));
        int x = 10;
        int i = 0;
        while (i < this.bar.menus.size()) {
            Menu m = (Menu)this.bar.menus.elementAt(i);
            String label = m.label;
            int w = g.getFontMetrics().stringWidth(label) + 10;
            g.setColor(i == this.selected ? SystemColor.activeCaption : Color.white);
            g.fillRect(x - 5, 1, w, this.h - 3);
            g.setColor(i == this.selected ? Color.white : Color.black);
            g.drawString(label, x, 12);
            x += w;
            ++i;
        }
        g.setColor(Color.black);
    }

    void setSelected(int i, int xofs) {
        Menu toOpen;
        if (this.selected != i) {
            this.selected = i;
            Graphics g = this.getGraphics();
            if (g != null) {
                this.paint(g);
            } else {
                this.repaint();
            }
        }
        Menu menu = toOpen = i == -1 ? null : (Menu)this.bar.menus.elementAt(i);
        if (this.open != toOpen && this.open != null) {
            this.open.win.setVisible(false);
        }
        this.open = toOpen;
        if (this.open != null) {
            this.open.show(xofs);
        }
    }

    public void processMouseEvent(MouseEvent me) {
        if (me.getID() != 506 && me.getID() != 501) {
            return;
        }
        int xofs = 5;
        int mx = me.getX();
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        g.setFont(g.getFont().deriveFont(1));
        FontMetrics fm = g.getFontMetrics();
        int i = 0;
        while (i < this.bar.menus.size()) {
            int nextOfs = xofs + 10 + fm.stringWidth(((Menu)this.bar.menus.elementAt((int)i)).label);
            if (mx >= xofs && mx < nextOfs) {
                this.setSelected(i, xofs);
                return;
            }
            xofs = nextOfs;
            ++i;
        }
        this.setSelected(-1, xofs);
    }
}

