/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Point;

public class Rectangle {
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void add(Rectangle r) {
        int x2 = Math.max(r.x + r.width, this.x + this.width);
        int y2 = Math.max(r.y + r.height, this.y + this.height);
        if (r.x < this.x) {
            this.x = r.x;
        }
        if (r.y < this.y) {
            this.y = r.y;
        }
        this.width = x2 - this.x;
        this.height = y2 - this.y;
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(int px, int py) {
        return px >= this.x && px < this.x + this.width && py >= this.y && py < this.y + this.width;
    }

    public Rectangle intersection(Rectangle r) {
        Rectangle result = new Rectangle(this.x, this.y, this.width, this.height);
        if (r.x > result.x) {
            result.width -= r.x - result.x;
            result.x = r.x;
        }
        if (r.y > result.y) {
            result.height -= r.y - result.y;
            result.y = r.y;
        }
        if (r.x + r.width < result.x + result.width) {
            result.width = r.x + r.width - result.x;
        }
        if (r.y + r.height < result.y + result.height) {
            result.height = r.y + r.height - result.y;
        }
        return result;
    }
}

