/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Scrollbar;

class ScrollManager {
    static final int BORDER_NONE = 0;
    static final int BORDER_SINGLE = 2;
    static final int BORDER_SHADOW = 5;
    Component component;
    Scrollbar hBar;
    Scrollbar vBar;
    int viewPortW;
    int viewPortH;
    int xOffset;
    int yOffset;
    int border;
    boolean clear;

    ScrollManager(Component component, int border) {
        this.component = component;
        this.border = border;
    }

    void paint(Graphics g) {
        Graphics g2;
        int w = this.component.w;
        int h = this.component.h;
        if (this.border == 5) {
            g.drawLine(2, 1, w - 4, 1);
            g.drawLine(2, h - 3, w - 3, h - 3);
            g.drawLine(3, h - 2, w - 4, h - 2);
            g.drawLine(1, 2, 1, h - 4);
            g.drawLine(w - 3, 2, w - 3, h - 3);
            g.drawLine(w - 2, 3, w - 2, h - 4);
        } else if (this.border == 2) {
            g.drawRect(0, 0, w - 1, h - 1);
        }
        if (this.vBar != null) {
            g2 = g.create(this.vBar.x, this.vBar.y, this.vBar.w, this.vBar.h);
            if (this.clear) {
                g2.clearRect(0, 0, this.vBar.w, this.vBar.h);
            }
            this.vBar.paint(g2);
            this.yOffset = this.vBar.currValue;
        } else {
            this.yOffset = 0;
        }
        if (this.hBar != null) {
            g2 = g.create(this.hBar.x, this.hBar.y, this.hBar.w, this.hBar.h);
            if (this.clear) {
                g2.clearRect(0, 0, this.hBar.w, this.hBar.h);
            }
            this.hBar.paint(g2);
            this.xOffset = this.hBar.currValue;
        } else {
            this.xOffset = 0;
        }
        this.clear = false;
        int b = this.border >> 1;
        g.clipRect(b, b, this.viewPortW, this.viewPortH);
        g.translate(b, b);
    }

    void doLayout(int virtualW, int virtualH) {
        this.viewPortW = this.component.w - this.border;
        this.viewPortH = this.component.h - this.border;
        int i = 0;
        while (i < 2) {
            if (virtualH > this.viewPortH) {
                if (this.vBar == null) {
                    this.clear = true;
                    this.vBar = new Scrollbar(1);
                    this.vBar.parent = this.component;
                    this.vBar.repaintParent = true;
                    this.vBar.setSize(this.vBar.getMinimumSize());
                }
                this.vBar.maxValue = virtualH - this.viewPortH;
                this.vBar.currVisible = this.viewPortH;
                this.vBar.blockIncrement = this.viewPortH;
                this.vBar.unitIncrement = 12;
                this.vBar.x = this.component.w - this.vBar.w - (this.border >> 1);
                this.vBar.y = this.border >> 1;
                this.vBar.h = this.component.h - this.border;
                this.viewPortW = this.component.w - this.border - this.vBar.w;
            } else {
                this.clear |= this.vBar != null;
                this.vBar = null;
            }
            if (virtualW > this.viewPortW) {
                if (this.hBar == null) {
                    this.clear = true;
                    this.hBar = new Scrollbar(0);
                    this.hBar.parent = this.component;
                    this.hBar.repaintParent = true;
                    this.hBar.setSize(this.hBar.getMinimumSize());
                }
                this.hBar.maxValue = virtualW - this.viewPortW;
                this.hBar.currVisible = this.viewPortW;
                this.hBar.blockIncrement = this.viewPortW;
                this.hBar.unitIncrement = 12;
                this.hBar.y = this.component.h - this.hBar.h - (this.border >> 1);
                this.hBar.x = this.border >> 1;
                this.hBar.w = this.viewPortW;
                this.viewPortH = this.component.h - this.hBar.h - this.border;
            } else {
                this.clear |= this.hBar != null;
                this.hBar = null;
            }
            ++i;
        }
        this.component.valid = true;
    }

    Component findComponentAt(int px, int py) {
        if (!this.component.visible || !this.component.contains(px, py)) {
            return null;
        }
        if (this.vBar != null && px > this.viewPortW) {
            return this.vBar;
        }
        if (this.hBar != null && py > this.viewPortH) {
            return this.hBar;
        }
        return this.component;
    }
}

