/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.ScrollManager;

public class ScrollPane
extends Container {
    Component child;
    ScrollManager scrollManager;

    public ScrollPane() {
        this.children = null;
        this.scrollManager = new ScrollManager(this, 2);
    }

    public Component add(String where, Component c) {
        this.child = c;
        c.parent = this;
        this.invalidate();
        return c;
    }

    public void paintAll(Graphics g) {
        if (this.child == null || !this.visible) {
            return;
        }
        this.scrollManager.paint(g);
        this.child.x = -this.scrollManager.xOffset;
        this.child.y = -this.scrollManager.yOffset;
        Graphics g2 = g.create(this.child.x, this.child.y, this.child.w, this.child.h);
        this.child.paintAll(g2);
    }

    public synchronized void doLayout() {
        if (this.child == null) {
            return;
        }
        Dimension d = this.child.getPreferredSize();
        this.scrollManager.doLayout(d.width, d.height);
        if (d.width < this.scrollManager.viewPortW) {
            d.width = this.scrollManager.viewPortW;
        }
        if (d.height < this.scrollManager.viewPortH) {
            d.height = this.scrollManager.viewPortH;
        }
        this.child.setSize(d);
        this.child.doLayout();
    }

    public Component findComponentAt(int px, int py) {
        Component target = this.scrollManager.findComponentAt(px, py);
        if (target != this) {
            return target;
        }
        return this.child.findComponentAt(px - this.child.x, py - this.child.y);
    }

    public Point getScrollPosition() {
        return new Point(this.scrollManager.hBar != null ? this.scrollManager.hBar.currValue : 0, this.scrollManager.vBar != null ? this.scrollManager.vBar.currValue : 0);
    }
}

