/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Scrollbar;

abstract class Scrollable
extends Component {
    Scrollbar vBar;
    Scrollbar hBar;
    int viewPortW;
    int viewPortH;

    Scrollable() {
    }

    public void paintAll(Graphics g) {
        if (!this.visible) {
            return;
        }
        int x0 = 0;
        int y0 = 0;
        if (this.vBar != null) {
            this.vBar.paint(g.create(this.vBar.x, this.vBar.y, this.vBar.w, this.vBar.h));
            y0 = this.vBar.currValue;
        }
        if (this.hBar != null) {
            this.hBar.paint(g.create(this.hBar.x, this.hBar.y, this.hBar.w, this.hBar.h));
            x0 = this.hBar.currValue;
        }
        g.clipRect(0, 0, this.viewPortW, this.viewPortH);
        this.paintContent(g, x0, y0);
    }

    abstract void paintContent(Graphics var1, int var2, int var3);

    abstract Dimension getVirtualSize();

    public synchronized void doLayout() {
        this.viewPortW = this.w;
        this.viewPortH = this.h;
        Dimension d = this.getVirtualSize();
        if (d.width < this.viewPortW) {
            d.width = this.viewPortW;
        }
        if (d.height < this.viewPortH) {
            d.height = this.viewPortH;
        }
        if (d.height > this.viewPortH) {
            if (this.vBar == null) {
                this.vBar = new Scrollbar(1);
                this.vBar.parent = this;
                this.vBar.repaintParent = true;
                this.vBar.setSize(this.vBar.getMinimumSize());
            }
            this.vBar.maxValue = d.height - this.h;
            this.vBar.currVisible = this.h;
            this.vBar.blockIncrement = this.h;
            this.vBar.unitIncrement = 12;
            this.vBar.x = this.w - this.vBar.w;
            this.vBar.y = 0;
            this.vBar.h = this.h;
            this.viewPortW = this.w - this.vBar.w;
        } else {
            this.vBar = null;
        }
        if (d.width > this.viewPortW) {
            if (this.hBar == null) {
                this.hBar = new Scrollbar(0);
                this.hBar.parent = this;
                this.hBar.repaintParent = true;
                this.hBar.setSize(this.hBar.getMinimumSize());
            }
            this.hBar.maxValue = d.width - this.w;
            this.hBar.currVisible = this.w;
            this.hBar.blockIncrement = this.w;
            this.hBar.unitIncrement = 12;
            this.hBar.y = this.h - this.hBar.h;
            this.hBar.x = 0;
            this.hBar.w = this.viewPortW;
            this.viewPortH = this.h - this.hBar.h;
        } else {
            this.hBar = null;
        }
        this.valid = true;
    }

    public Component findComponentAt(int px, int py) {
        if (!this.visible || !this.contains(px, py)) {
            return null;
        }
        if (this.vBar != null) {
            if (px > this.viewPortW) {
                return this.vBar;
            }
            px += this.vBar.currValue;
        }
        if (this.hBar != null) {
            if (py > this.viewPortH) {
                return this.hBar;
            }
            py += this.hBar.currValue;
        }
        return this;
    }
}

