/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import de.kawt.ImageItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.TooManyListenersException;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;

public class Scrollbar
extends Component {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    int minW = 7;
    int minH = 12;
    int minValue;
    int maxValue;
    int currValue;
    int orientation;
    int currVisible;
    int scrPos;
    int scrBarSize;
    int scrSpace;
    int unitIncrement = 1;
    int blockIncrement;
    int scrollType = -1;
    boolean dragging = false;
    AdjustmentListener adjustmentListener;
    boolean repaintParent;

    public Scrollbar() {
        this(1);
    }

    public Scrollbar(int orientation) {
        this(orientation, 0, 10, 0, 100);
    }

    public Scrollbar(int orientation, int value, int visible, int minimum, int maximum) {
        this.orientation = orientation;
        this.currValue = value;
        this.currVisible = visible;
        this.minValue = minimum;
        this.maxValue = maximum;
        this.blockIncrement = this.currVisible;
    }

    public void addAdjustmentListener(AdjustmentListener al) {
        if (this.adjustmentListener != null) {
            throw new TooManyListenersException();
        }
        this.adjustmentListener = al;
    }

    public int getMaximum() {
        return this.maxValue;
    }

    public int getMinimum() {
        return this.minValue;
    }

    public Dimension getMinimumSize() {
        if (this.orientation == 1) {
            return new Dimension(this.minW, this.minH);
        }
        return new Dimension(this.minH, this.minW);
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public int getValue() {
        return this.currValue;
    }

    public void paint(Graphics g) {
        this.scrSpace = (this.orientation == 0 ? this.w : this.h) - 12;
        this.scrBarSize = this.scrSpace * this.currVisible / (this.maxValue - this.minValue + this.currVisible);
        if (this.scrBarSize < 4) {
            this.scrBarSize = 4;
        }
        this.scrSpace -= this.scrBarSize;
        this.scrPos = 6 + this.scrSpace * (this.currValue - this.minValue) / (this.maxValue - this.minValue);
        if (this.orientation != 0) {
            int middle = this.w / 2;
            g.drawImage(ImageItem.getImage(this.scrollType == 2 ? 4 : 0), middle - 3, 0, null);
            g.drawImage(ImageItem.getImage((this.scrollType == 1 ? 4 : 0) | 1), middle - 3, this.h - 6, null);
            g.setColor(Color.gray);
            if (Graphics.monochrome) {
                g.drawLine(middle - 1, 6, middle - 1, this.h - 7);
                g.drawLine(middle, 7, middle, this.h - 8);
                g.drawLine(middle + 1, 6, middle + 1, this.h - 7);
            } else {
                g.fillRect(middle - 1, 6, 3, this.h - 12);
            }
            g.setColor(Color.black);
            g.fillRect(middle - 1, this.scrPos, 3, this.scrBarSize);
            g.setColor(Color.white);
            g.drawLine(middle - 1, this.scrPos - 1, middle + 1, this.scrPos - 1);
            g.drawLine(middle - 1, this.scrPos + this.scrBarSize, middle + 1, this.scrPos + this.scrBarSize);
        } else {
            int middle = this.h / 2;
            g.drawImage(ImageItem.getImage((this.scrollType == 2 ? 4 : 0) | 2), 0, middle - 3, null);
            g.drawImage(ImageItem.getImage((this.scrollType == 1 ? 4 : 0) | 3), this.w - 6, middle - 3, null);
            g.setColor(Color.gray);
            if (Graphics.monochrome) {
                g.drawLine(6, middle - 1, this.w - 7, middle - 1);
                g.drawLine(6, middle, this.w - 7, middle);
                g.drawLine(6, middle + 1, this.w - 7, middle + 1);
                g.setXORMode(Color.black);
                g.drawLine(6, middle, this.w - 7, middle);
                g.setPaintMode();
            } else {
                g.fillRect(6, middle - 1, this.w - 12, 3);
            }
            g.setColor(Color.black);
            g.fillRect(this.scrPos, middle - 1, this.scrBarSize, 3);
            g.setColor(Color.white);
            g.drawLine(this.scrPos, middle - 1, this.scrPos, middle + 1);
            g.drawLine(this.scrPos + this.scrBarSize, middle - 1, this.scrPos + this.scrBarSize, middle + 1);
        }
    }

    public void processMouseEvent(MouseEvent e) {
        int id = e.getID();
        int mpos = this.orientation != 0 ? e.getY() : e.getX();
        boolean befBar = mpos <= this.scrPos + this.scrBarSize;
        boolean behBar = mpos >= this.scrPos;
        int newVal = this.currValue;
        this.scrollType = -1;
        if (id == 501 && befBar && behBar) {
            this.dragging = true;
        } else if (id == 506 && this.dragging) {
            newVal = this.minValue + (mpos - 7 - this.scrBarSize / 2) * (this.maxValue - this.minValue) / this.scrSpace;
            this.scrollType = 5;
        } else if (id == 506 || id == 501) {
            this.dragging = false;
            if (befBar) {
                if (mpos <= 4) {
                    newVal = this.currValue - this.unitIncrement;
                    this.scrollType = 2;
                } else {
                    newVal = this.currValue - this.blockIncrement;
                    this.scrollType = 3;
                }
            } else if (mpos >= this.h - 4 && this.orientation != 0 || mpos >= this.w - 4 && this.orientation == 0) {
                newVal = this.currValue + this.unitIncrement;
                this.scrollType = 1;
            } else {
                newVal = this.currValue + this.blockIncrement;
                this.scrollType = 4;
            }
        } else if (id == 502) {
            if (!this.repaintParent) {
                this.paint(this.getGraphics());
            } else {
                this.parent.repaint(this.x, this.y, this.w, this.h);
            }
        }
        if (newVal > this.maxValue) {
            newVal = this.maxValue;
        }
        if (newVal < this.minValue) {
            newVal = this.minValue;
        }
        if (this.currValue != newVal) {
            this.currValue = newVal;
            if (!this.repaintParent) {
                this.paint(this.getGraphics());
            } else {
                this.parent.repaint();
            }
            if (this.adjustmentListener != null) {
                this.adjustmentListener.adjustmentValueChanged(new AdjustmentEvent(this, 601, this.scrollType, this.currValue));
            }
        }
    }

    public void setBlockIncrement(int inc) {
        this.blockIncrement = inc;
    }

    public void setMaximum(int max) {
        this.maxValue = max;
        this.repaint();
    }

    public void setMinimum(int min) {
        this.minValue = min;
        this.repaint();
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
        this.valid = false;
    }

    public void setUnitIncrement(int inc) {
        this.unitIncrement = inc;
    }

    public void setValue(int v) {
        this.currValue = v;
        this.repaint();
    }

    public void setValues(int val, int visible, int min, int max) {
        this.maxValue = max;
        this.minValue = min;
        this.currVisible = visible;
        this.currValue = val;
        this.repaint();
    }
}

